<?php
namespace app\admin\controller;


use app\admin\model\HomeConfig as mHomeConfig;
use app\admin\model\HomeConfigCate;
use app\common\model\Img;
use think\Exception;

class HomeConfig extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    public function cate_list(){
        $pageSize =10 ;
        $cate_list = HomeConfigCate::where("isdeleted",0)->paginate($pageSize);
        $this->assign("cate_list",$cate_list);
        return view("/admin/home_config/cate_list");
    }
    public function cate_edit(int $id=0){
        $home_cate = HomeConfigCate::where("isdeleted",0)->where("id",$id)->find();
        $this->assign("home_cate",$home_cate);
        return view("/admin/home_config/cate_edit");
    }
    public function cate_save(){
        $id = request()->param('id',0,'intval');
        try {
            if($id==0){
                $app = new HomeConfigCate();
                $app['title'] = trim(request()->param('name'));
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->validate(['size'=>2048000,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不正确');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 11;
                $img['current'] = time();
                $img->save();
                $app['img_id'] = $img->id;
                $app->save();
            }else{
                $app = HomeConfigCate::where('isdeleted',0)->where('id',$id)->find();
                if(empty($app)){
                    $this->error("该项已被删除");
                }
                $app['title'] = trim(request()->param('name'));
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $app->save();
            }
        } catch (Exception $e) {
            unlink('../public/uploads/static_data/'.$info->getExtension());
        }
        
       $this->redirect(url("/home_config/cate_list"));
    }
    public function cate_del(int $id=0){
        $data = HomeConfigCate::where('id',$id)->find();
        if ($data){
            $data['isdeleted'] = 1;
            $data->save();
            $this->success('删除成功',url('/home_config/cate_list'));
        }else{
            $this->success('删除项不存在',url('/home_config/cate_list'));
        }
    }
    
    
    public function list(){
        $pageSize =10 ;
        $home_config_list = mHomeConfig::where("isdeleted",0)->paginate($pageSize);
        $this->assign("home_config_list",$home_config_list);
        return view("/admin/home_config/list");
    }
    public function edit(int $id=0){
        $home_cate_list = HomeConfigCate::where("isdeleted",0)->select();
        $home = mHomeConfig::where("isdeleted",0)->where('id',$id)->find();
        $this->assign("home_config",$home);
        $this->assign("home_cate_list",$home_cate_list);
        return view("/admin/home_config/edit");
    }
    public function save(){
        //1.获取职位类别
        $id = request()->param('id',0,'intval');
        
        try {
            if($id==0){
                $app = new mHomeConfig();
                $app['title'] = trim(request()->param('name'));
                $app['home_config_cate_id'] = request()->param('home_config_cate_id');
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->rule('uniqid')->move( '../public/uploads/static_data/');
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 9;
                $img['current'] = time();
                $img->save();
                $app['img_id'] = $img->id;
                $app->save();
            }else{
                $app = mHomeConfig::where('isdeleted',0)->where('id',$id)->find();
                if(empty($app)){
                    $this->error("该项已被删除");
                }
                $is_cover = request()->param('is_cover');
                if(strtolower($is_cover)=="on"){
                    $img = new Img();
                    $file = request()->file('img');
                    $info = $file->validate(['size'=>102400*5,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                    if (!$info){
                        $this->error('图片太大或格式不正确');
                    }
                    $img['img_name'] =   $info->getSaveName();
                    $img_url = "/uploads/static_data/";
                    $img_url_array = explode("/",$info->getExtension());
                    $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                    $img['img_url'] = $img_url;
                    $img['img_type'] = 9;
                    $img['current'] = time();
                    $img->save();
                    $temp_img = Img::get($app['img_id']);
                    unlink("../public".$temp_img["img_url"].$temp_img['img_name']);
                    Img::destroy($app['img_id']);
                    $app['img_id'] = $img->id;
                }
                $app['home_config_cate_id'] = request()->param('home_config_cate_id');
                $app['title'] = trim(request()->param('name'));
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $app->save();
            }
        } catch (Exception $e) {
           $this->error($e->getMessage());
        }
        $this->success("保存成功",url("/home_config/list"));
    }
    public function del(int $id=0){
        $data = mHomeConfig::where('id',$id)->find();
        if ($data){
            $data['isdeleted'] = 1;
            $data->save();
            $this->success('删除成功',url('/home_config/list'));
        }else{
            $this->success('删除项不存在',url('/home_config/list'));
        }
    }
}