<?php
namespace app\admin\controller;


use app\servicehelp\model\QuestionCate as mQuestionCate;
use app\common\model\Img;
use think\Exception;
use app\servicehelp\model\Question;

class QuestionCate extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize = 10;
        $cate_list = mQuestionCate::where('isdeleted',0)->order('current','desc')->paginate($pageSize);
        $this->assign('cate_list',$cate_list);
        return view("/admin/question/cate_list");
    }
    public function edit(int $id=0){
        $question_cate = mQuestionCate::where('isdeleted',0)->where('id',$id)->find();
        $this->assign('question_cate',$question_cate);
        return view("/admin/question/cate_edit");
    }
    public function save(){
        
        //1.获取职位类别
        $id = request()->param('id',0,'intval');
        
        try {
            if($id==0){
                $joinCate = new mQuestionCate();
                $joinCate['title'] = trim(request()->param('name'));
                $joinCate['user_id'] = session('user')['id'];
                $joinCate['current'] = time();
                $joinCate['isdeleted'] = 0;
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不正确');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 3;
                $img['current'] = time();
                $img->save();
                $joinCate['img_id'] = $img->id;
                $joinCate->save();
            }else{
                $joinCate = mQuestionCate::where('isdeleted',0)->where('id',$id)->find();
                if(empty($joinCate)){
                    $this->error("该分类已被删除");
                }
                $is_cover = request()->param('is_cover');
                if(strtolower($is_cover)=="on"){
                    $img = new Img();
                    $file = request()->file('img');
                    $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                    if (!$info){
                        $this->error('图片太大或格式不正确');
                    }
                    $img['img_name'] =   $info->getSaveName();
                    $img_url = "/uploads/static_data/";
                    $img_url_array = explode("/",$info->getExtension());
                    $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                    $img['img_url'] = $img_url;
                    $img['img_type'] = 3;
                    $img['current'] = time();
                    $img->save();
                    $temp_img = Img::get($joinCate['img_id']);
                    unlink("../public".$temp_img["img_url"].$temp_img['img_name']);
                    Img::destroy($joinCate['img_id']);
                    $joinCate['img_id'] = $img->id;
                }
                $joinCate['title'] = trim(request()->param('name'));
                $joinCate['user_id'] = session('user')['id'];
                $joinCate['current'] = time();
                $joinCate['isdeleted'] = 0;
                $joinCate->save();
            }
        } catch (Exception $e) {
            $this->error($e->getMessage());
        }
        $this->redirect(url("/questionCate/list"));
    }
    public function del(int $id=0){
        $join_num = Question::where("isdeleted",0)->where("question_cate_id",$id)->count();
        if($join_num>0){
            $this->error("该分类下有问题信息，不能删除",url("/questionCate/list"));
        }
        $join_cate = mQuestionCate::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($join_cate)){
            $join_cate['isdeleted'] = 1;
            $join_cate->save();
            if(!empty($join_cate['img_id'])&&$join_cate['img_id']!=0){
                $img = Img::get($join_cate['img_id']);
                unlink('../public'.$img["img_url"].$img['img_name']);
                Img::destroy($join_cate['img_id']);
            }
        }
        $this->success("删除成功",url("/questionCate/list"));
    }
}