<?php
namespace app\join\controller;

use app\common\controller\Base;
use app\join\model\JoinCate;
use app\join\model\Join as mjoin;

class Join extends Base
{
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function list(){
        
        $join_cate = new JoinCate();
        $join = new mjoin();
        $join_list = $join->where('isdeleted',0)->order('join_cate_id','asc')->order('current','desc')->select();
        $join_list = $this->dealData($join_list);
        $join_cate_list = $join_cate->where('isdeleted',0)->order('id','asc')->select();
        $join_cate_list = $this->dealData($join_cate_list);
        $this->assign('url',$this->url);
        $this->assign('join_image',$this->getImage(2));
        $this->assign('join_cate_list',$join_cate_list);
        $this->assign('join_list',$join_list);
        return view("/home/join/list");
    }
    
    public function ajax_list(){
        $pageSize = 5;
        $join_list = mjoin::where('isdeleted',0)->where('isrelease',1)->order('current','desc')->paginate($pageSize);
        
        $page = input('page',1,'intval');
        $count = $join_list->total();
        
        $page_num = $count%$pageSize==0?$count/$pageSize:intval(($count/$pageSize)+1);
        $first = $page>1?$page-1:'false';
        $second = $page<$page_num?$page+1:'false';
        
        $this->assign('url',$this->url);
        if($page<1||$page>$page_num){
            return view("/home/public/error");
        }
        
        $this->assign('first',$first);
        $this->assign('second',$second);
        $this->assign('join_list',$join_list);
    }
}