<?php
namespace app\index\controller;

use app\common\controller\Base;
use app\servicehelp\model\Question;
use app\news\model\News;
use app\admin\model\App;
use app\admin\model\HomeConfig;
use think\Request;

class Index extends Base
{
    public function index()
    {
        $app_list = App::where("isdeleted",0)->order('num','asc')->select();
        $help_list = Question::where("isdeleted",0)->order("current","desc")->paginate(4);
        $news_list = News::where("isdeleted",0)->order("current","desc")->paginate(4);
        
        $this->assign('app_list',$app_list);
        $this->assign('help_list',$help_list);
        $this->assign('news_list',$news_list);
        $this->assign('url',$this->url);
        return view("/home/index/Index/index");
    }

    public function mobile()
    {
        $app_list = App::where("isdeleted",0)->order('num','asc')->select();
        $help_list = Question::where("isdeleted",0)->order("current","desc")->paginate(4);
        $news_list = News::where("isdeleted",0)->order("current","desc")->paginate(4);

        $this->assign('app_list',$app_list);
        $this->assign('help_list',$help_list);
        $this->assign('news_list',$news_list);
        $this->assign('url',$this->url);
        return view("/home/index/Index/wap_index");
    }
  
    public function hello($name = 'ThinkPHP5')
    {
        return 'hello,' . $name;
    }
  
    public function is_mobile()
    {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $mobile_agents = array("240x320", "acer", "acoon", "acs-", "abacho", "ahong", "airness", "alcatel",
            "amoi", "android", "anywhereyougo.com", "applewebkit/525", "applewebkit/532", "asus", "audio",
            "au-mic", "avantogo", "becker", "benq", "bilbo", "bird", "blackberry", "blazer", "bleu",
            "cdm-", "compal", "coolpad", "danger", "dbtel", "dopod", "elaine", "eric", "etouch", "fly ",
            "fly_", "fly-", "go.web", "goodaccess", "gradiente", "grundig", "haier", "hedy", "hitachi",
            "htc", "huawei", "hutchison", "inno", "ipad", "ipaq", "iphone", "ipod", "jbrowser", "kddi",
            "kgt", "kwc", "lenovo", "lg ", "lg2", "lg3", "lg4", "lg5", "lg7", "lg8", "lg9",
            "lg-", "lge-", "lge9", "longcos", "maemo",
            "mercator", "meridian", "micromax", "midp", "mini", "mitsu", "mmm", "mmp", "mobi", "mot-",
            "moto", "nec-", "netfront", "newgen", "nexian", "nf-browser", "nintendo", "nitro", "nokia",
            "nook", "novarra", "obigo", "palm", "panasonic", "pantech", "philips", "phone", "pg-",
            "playstation", "pocket", "pt-", "qc-", "qtek", "rover", "sagem", "sama", "samu", "sanyo",
            "samsung", "sch-", "scooter", "sec-", "sendo", "sgh-", "sharp", "siemens", "sie-", "softbank",
            "sony", "spice", "sprint", "spv", "symbian", "tablet", "talkabout", "tcl-", "teleca", "telit",
            "tianyu", "tim-", "toshiba", "tsm", "up.browser", "utec", "utstar", "verykool", "virgin",
            "vk-", "voda", "voxtel", "vx", "wap", "wellco", "wig browser", "wii", "windows ce",
            "wireless", "xda", "xde", "zte");
        $is_mobile = false;
        foreach ($mobile_agents as $device) {
            if (stristr($user_agent, $device)) {
                $is_mobile = true;
                break;
            }
        }
        return $is_mobile;
    }
  
    public function huatai(Request $request)
    {
      $this->assign('domain',$request->domain());
       $this->assign('url',$this->url);
       $this->assign('imageList',$this->getImage(3));
        return view("/home/index/huatai");
    }

    public function getConfig(){
        $type = input('type');
        //获取首页背景图
        $bannerImg = $this->getImage($type);
        //获取按钮
        $button=array();
        return json(['banner'=>$bannerImg,'button'=>$button] );
    }
}
