<?php
namespace app\common\controller;


use app\admin\model\HomeConfig;

class Base extends Error
{
    public $url = "";
    public $logo_url = "";
    public $other_logo_url = "";
    public $vedio_url = "";
    public $host_name = "";
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function initialize(){
        $this->url = request()->controller();
        $this->host_name = request()->domain();
        $other_logo = $this->getImage(4);
        $index_logo = $this->getImage(5);
        $vedio = HomeConfig::where("home_config_cate_id",1)->where("isdeleted",0)->Order("current","desc")->find();
        if(!empty($vedio)){
            $this->vedio_url = $vedio->img->img_url.$vedio->img->img_name;
        }
        $this->getNav();
        $this->assign("other_logo_url",$other_logo);
        $this->assign("logo_url",$index_logo);
        $this->assign("vedio_url",$this->vedio_url);
        $this->assign("host_name",$this->host_name);
    }

    public function getImage($type){
        //获取首页背景图
        $bannerImgId = db('advertisement')->where(array('type'=>$type,'is_display'=>1))->field('id,mintype')->find();
        $where[] = ['starttime','<',time()];
        $where[] = ['endtime','>',time()];
        $where[] = ['starthour','<',date('h',time())];
        $where[] = ['endhour','>',date('h',time())];
        $cont = db('advertisement_cont')->where($where)->where(array('advert_id'=>$bannerImgId['id']))->field('picSrc')->select();
        $imagePre = "https://oss.3yakj.com/application_static_data";
        $bannerImg = [];
        if ($bannerImgId['mintype'] == 0){
            $bannerImg = $imagePre.$cont[mt_rand(0,count($cont)-1)]['picSrc'];
        }else{
            foreach ($cont as $value){
                $bannerImg[] = $imagePre.$value['picSrc'];
            }
        }
        return $bannerImg;
    }

    public function getNav(){
        $nav = db('menu')->where(array('status'=>1,'type'=>0))->field('id,title,url,show_type')->order('order desc')->select();
        foreach ($nav as $key=>$value){
            if (!empty($value['url'])){
                $class = explode('.html',$value['url'])[0];
                if ($class !== '/'){
                    $nav[$key]['class'] = explode('/',$class)[1];
                    if ($nav[$key]['class'] == 'index'){
                        $nav[$key]['class'] = 'home';
                    }
                }else{
                    $nav[$key]['class'] = 'home';
                }
            }else{
                $nav[$key]['class'] = '';
            }
            $child = db('menu_child')->where(array('pid'=>$value['id'],'status'=>1))->field('title,show_type,url')->order('order desc')->select();
            $nav[$key]['child'] = $child;
        }
        $this->assign('nav',$nav);
    }
}