<?php
namespace app\servicehelp\controller;

use app\common\controller\Base;
use app\servicehelp\model\QuestionCate;
use app\common\model\Img;
use app\servicehelp\model\Question;

class ServiceHelp extends Base
{
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function servicehelp(){
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
        for($n=0;$n<count($question_cate_list);$n++){
            $img = Img::get(intval($question_cate_list[$n]['img_id']));
            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
        }
        
        
        $this->assign('url',$this->url);
        $this->assign('question_cate_list',$question_cate_list);
        return view("/home/servicehelp/service");
    }
    public function service(){
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
//        for($n=0;$n<count($question_cate_list);$n++){
//            $img = Img::get(intval($question_cate_list[$n]['img_id']));
//            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
//        }
        
        
        $this->assign('url',$this->url);
        $this->assign('question_cate_list',$question_cate_list);
        return view("/home/servicehelp/service");
    }
    public function help(){
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
//        for($n=0;$n<count($question_cate_list);$n++){
//            $img = Img::get(intval($question_cate_list[$n]['img_id']));
//            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
//        }
        $question_list = array();
        $cate = new QuestionCate();
        if(count($question_cate_list)>0){
            $cate = QuestionCate::where('isdeleted',0)->where('id',$question_cate_list[0]['id'])->find();
            $question_list = Question::where('isdeleted',0)->where('question_cate_id',$question_cate_list[0]['id'])->order('current','desc')->paginate(10, false, [
                'query' => request()->param()
            ]);
            $pattern = '/\[\d+\]/';
            $matches = array();
            for($m = 0;$m < count($question_list);$m++){
                preg_match_all($pattern, $question_list[$m]['content'], $matches);
                for($n=0;$n<count($matches[0]);$n++){
                    $img_id = str_replace("[","",$matches[0][$n]);
                    $img_id = str_replace("]","",$img_id);
                    $img = Img::get(intval($img_id));
                    $question_list[$m]['content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$question_list[$m]['content']);
                }
                
            }
        }
        $this->assign('q_id',0);
        $this->assign('question',['title'=>'','content'=>'']);
        $this->assign('cate',$cate);
        $this->assign('cate_id',0);
        $this->assign('url',$this->url);
        $this->assign('question_list',$question_list);
        $this->assign('question_cate_list',$question_cate_list);
        return view("/home/servicehelp/help");
    }
    
    public function cate(){
        $cate_id = input('id',0,'intval');
        $this->assign('url',$this->url);
        if($cate_id==0){
            $this->redirect('/servicehelp/help.html');
        }
        
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
        for($n=0;$n<count($question_cate_list);$n++){
            $img = Img::get(intval($question_cate_list[$n]['img_id']));
            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
        }
        
        $cate = QuestionCate::where('isdeleted',0)->where('id',$cate_id)->find();
    
        if(empty($cate)){
//            return view("/home/public/error");
        }
        $question_list = Question::where('isdeleted',0)->where('question_cate_id',$cate_id)->order('current','desc')->paginate(10, false, [
            'query' => request()->param()
        ]);
        $pattern = '/\[\d+\]/';
        $matches = array();
        for($m = 0;$m < count($question_list);$m++){
            preg_match_all($pattern, $question_list[$m]['content'], $matches);
            for($n=0;$n<count($matches[0]);$n++){
                $img_id = str_replace("[","",$matches[0][$n]);
                $img_id = str_replace("]","",$img_id);
                $img = Img::get(intval($img_id));
                $question_list[$m]['content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$question_list[$m]['content']);
            }
            
        }
        $this->assign('q_id',0);
        $this->assign('question',['title'=>'','content'=>'']);
        $this->assign('cate',$cate);
        $this->assign('cate_id',$cate_id);
        $this->assign('question_cate_list',$question_cate_list);
        $this->assign('question_list',$question_list);
        return view("/home/servicehelp/help");
    }
    public function question(){
        $question_id = input('id',0,'intval');
        if($question_id==0){
            $this->redirect('/servicehelp/help.html');
        }
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
//        for($n=0;$n<count($question_cate_list);$n++){
//            $img = Img::get(intval($question_cate_list[$n]['img_id']));
//            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
//        }
        
        $question = Question::where('isdeleted',0)->where('id',$question_id)->find();
        $this->assign('url',$this->url);
        if(empty($question)){
            return view("/home/public/error");
        }
        
        $pattern = '/\[\d+\]/';
        $matches = array();
        preg_match_all($pattern, $question['content'], $matches);
        for($n=0;$n<count($matches[0]);$n++){
            $img_id = str_replace("[","",$matches[0][$n]);
            $img_id = str_replace("]","",$img_id);
            $img = Img::get(intval($img_id));
            $question['content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$question['content']);
        }
            
        $cate = QuestionCate::where('isdeleted',0)->where('id',$question['question_cate_id'])->find();
        $this->assign('q_id',$question_id);
        $this->assign('question',$question);
        $this->assign('cate',$cate);
        $this->assign('cate_id',$cate['id']);
        $this->assign('question_cate_list',$question_cate_list);
        return view("/home/servicehelp/help");
    }
    public function search(){
        $key_str = input('s_key','');
        $question_cate_list =QuestionCate::where('isdeleted',0)->select();
//        for($n=0;$n<count($question_cate_list);$n++){
//            $img = Img::get(intval($question_cate_list[$n]['img_id']));
//            $question_cate_list[$n]['img_url'] = $img['img_url'].$img['img_name'];
//        }
        
        $question_list = Question::where('isdeleted',0)->whereLike('title',"%".$key_str."%")->order('current','desc')->paginate(10, false, [
            'query' => request()->param()
        ]);
        $pattern = '/\[\d+\]/';
        $matches = array();
        for($m = 0;$m < count($question_list);$m++){
            preg_match_all($pattern, $question_list[$m]['content'], $matches);
            for($n=0;$n<count($matches[0]);$n++){
                $img_id = str_replace("[","",$matches[0][$n]);
                $img_id = str_replace("]","",$img_id);
                $img = Img::get(intval($img_id));
                $question_list[$m]['content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$question_list[$m]['content']);
            }
            
        }
        $cate = ['title'=>'查询结果'];
        $this->assign('q_id',0);
        $this->assign('question',['title'=>'','content'=>'']);
        $this->assign('cate',$cate);
        $this->assign('cate_id',0);
        $this->assign('url',$this->url);
        $this->assign('question_cate_list',$question_cate_list);
        $this->assign('question_list',$question_list);
        return view("/home/servicehelp/help");
    }
}