<?php
use think\facade\Route;

// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2018 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------

Route::get('think', function () {
    return 'hello,ThinkPHP5!';
});

Route::get('home/', 'index/Index/index');
Route::get('', 'index/Index/index');
Route::get('mobile', 'index/Index/mobile');
Route::any('uploads_file', 'admin/Uploads/uploads');
Route::post('getConfig', 'index/Index/getConfig');


Route::get('hello/:name', 'index/hello');
Route::get('fanjiao_login', 'admin/Login/login');
Route::any('dologin', 'admin/Login/dologin');
Route::any('logout', 'admin/Login/logout');


Route::group('admin', [
    '/welcome'						=>  'admin/AdminIndex/welcome',
    '/index'						=>  'admin/AdminIndex/index',
    '/'						=>  'admin/AdminIndex/index',
],['ext'=>'html'],['id'=>'\d+']);


Route::group('home', [
    '/'						=>  'index/Index/index',
],['ext'=>'html'],['id'=>'\d+']);

Route::group('news', [
    '/save'					=>	'admin/News/save',
    '/del'					=>	'admin/News/del',
    '/delAll'                =>'admin/News/delAll',
    '/edit'					=>	'admin/News/edit',
    '/list'					=>	'admin/News/list',
    ':id'					=>	'news/News/detail',
    '/'						=>  'news/News/list',
    '/page:num'						=>  'news/News/list',
],['ext'=>'html'],['id'=>'\d+','num'=>'\d+']);

Route::group('joinCate', [
    '/del'						=>  'admin/JoinCate/del',
    '/delAll'               =>'admin/JoinCate/delAll',
    '/save'						=>  'admin/JoinCate/save',
    '/edit'						=>  'admin/JoinCate/edit',
    '/list'						=>  'admin/JoinCate/list',
    '/'						=>  'admin/JoinCate/list',
],['ext'=>'html'],['id'=>'\d+']);


Route::group('join', [
    '/save'						=>  'admin/Join/save',
    '/del'						=>  'admin/Join/del',
    '/delAll'               =>'admin/Join/delAll',
    '/edit'						=>  'admin/Join/edit',
    '/list'						=>  'admin/Join/list',
    '/'						=>  'join/Join/list',
],['ext'=>'html'],['id'=>'\d+']);


Route::group('contact', [
    '/'						=>  'about/About/contact',
],['ext'=>'html'],['id'=>'\d+']);

Route::group('aboutus', [
    '/vipterms'	              => 'about/About/vipterms',
    '/agreement'		      => 'about/About/agreement',
    '/us'					  => 'about/About/us',
    '/'						  => 'about/About/aboutus',
],['ext'=>'html'],[]);


Route::group('app_manage', [
    '/qc'	                  => 'admin/AppManage/qc',
    '/ios'		              => 'admin/AppManage/ios',
    '/android'				  => 'admin/AppManage/android',
    '/list'						  => 'admin/AppManage/list',
    '/edit'						  => 'admin/AppManage/edit',
    '/save'						  => 'admin/AppManage/save',
    '/del'						  => 'admin/AppCateManage/del',
    '/cate_list'						  => 'admin/AppCateManage/list',
    '/cate_edit'						  => 'admin/AppCateManage/edit',
    '/cate_save'						  => 'admin/AppCateManage/save',
    '/cate_del'						  => 'admin/AppCateManage/cate_del',
    '/delAll'						  => 'admin/AppCateManage/delAll',
],['ext'=>'html'],[]);

Route::group('gameCate', [
    '/cate_del'						  => 'admin/GameCate/del',
    '/delAll'						  => 'admin/GameCate/delAll',
    '/cate_list'						  => 'admin/GameCate/list',
    '/cate_edit'						  => 'admin/GameCate/edit',
    '/cate_save'						  => 'admin/GameCate/save',
    '/'						  => 'admin/GameCate/list',
],['ext'=>'html'],[]);

Route::group('game_manage', [
    '/list'						  => 'admin/Game/list',
    '/edit'						  => 'admin/Game/edit',
    '/save'						  => 'admin/Game/save',
    '/'						  => 'admin/Game/list',
],['ext'=>'html'],[]);
Route::group('game', [
    '/list'						  => 'game/Game/list',
    '/'						  => 'game/Game/list',
],['ext'=>'html'],['id'=>'\d+']);

Route::group('home_config', [
    '/cate_list'	                  => 'admin/HomeConfig/cate_list',
    '/cate_edit'		              => 'admin/HomeConfig/cate_edit',
    '/cate_save'		              => 'admin/HomeConfig/cate_save',
    '/cate_del'		              => 'admin/HomeConfig/cate_del',
    '/list'	                  => 'admin/HomeConfig/list',
    '/edit'		              => 'admin/HomeConfig/edit',
    '/save'		              => 'admin/HomeConfig/save',
    '/del'		              => 'admin/HomeConfig/del',
    '/delAll'				  => 'admin/HomeConfig/delAll',
],['ext'=>'html'],[]);

Route::group('about', [
    '/vipterms'	              => 'admin/About/vipterms',
    '/vipterms_edit'	      => 'admin/About/vipterms_edit',
    '/vipterms_save'	      => 'admin/About/vipterms_save',
    '/vipterms_del'	      => 'admin/About/vipterms_del',
    '/agreement'		      => 'admin/About/agreement',
    '/agreement_edit'		  => 'admin/About/agreement_edit',
    '/agreement_save'		  => 'admin/About/agreement_save',
    '/agreement_del'		  => 'admin/About/agreement_del',
    '/us'					  => 'admin/About/us',
    '/us_edit'				  => 'admin/About/us_edit',
    '/us_save'				  => 'admin/About/us_save',
    '/us_del'				  => 'admin/About/us_del',
    '/contact'					  => 'admin/About/contact',
    '/contact_edit'				  => 'admin/About/contact_edit',
    '/contact_save'				  => 'admin/About/contact_save',
    '/contact_del'				  => 'admin/About/contact_del',
    '/delAll'				  => 'admin/About/delAll',
],['ext'=>'html'],[]);

Route::group('servicehelp', [
    '/search'		      => 'servicehelp/ServiceHelp/search',
    '/question'		      => 'servicehelp/ServiceHelp/question',
    '/cate'		      => 'servicehelp/ServiceHelp/cate',
    '/help'		      => 'servicehelp/ServiceHelp/help',
    '/service'					  => 'servicehelp/ServiceHelp/service',
    '/'						  => 'servicehelp/ServiceHelp/service',
],['ext'=>'html'],['id'=>'\d+']);


Route::group('question', [
    '/save'		      => 'admin/Question/save',
    '/del'		      => 'admin/Question/del',
    '/delAll'		      => 'admin/Question/delAll',
    '/edit'		      => 'admin/Question/edit',
    '/list'					  => 'admin/Question/list',
    '/'						  => 'admin/Question/list',
],['ext'=>'html'],['id'=>'\d+']);

Route::group('questionCate', [
    '/save'		      => 'admin/QuestionCate/save',
    '/del'		      => 'admin/QuestionCate/del',
    '/delAll'		      => 'admin/QuestionCate/delAll',
    '/edit'		      => 'admin/QuestionCate/edit',
    '/list'					  => 'admin/QuestionCate/list',
    '/'						  => 'admin/QuestionCate/list',
],['ext'=>'html'],['id'=>'\d+']);

//banner配置
Route::group('banner', [
    '/save'		      => 'admin/banner/save',
    '/del'		      => 'admin/banner/del',
    '/delAll'		      => 'admin/banner/delAll',
    '/edit'		      => 'admin/banner/edit',
    '/list'					  => 'admin/banner/list',
    '/'						  => 'admin/banner/list',
],['ext'=>'html'],['id'=>'\d+']);

// Route::group('blog', [
//     ':year/:month'	=>	'blog/archive',
//     ':cate'				  => 'blog/index',
//     ':id'					=>	'blog/read',
//     '/'						=>  'blog/index',
// ],['ext'=>'html'],['year'=>'\d{4}','month'=>'\d{2}','cate'=>'[a-zA-Z]+','id'=>'\d+']);


return [

];
