<?php
namespace app\admin\controller;


use app\about\model\About as mAbout;
use app\common\model\Img;
use think\facade\App;

class About extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }

    public function __construct(\think\App $app = null)
    {
        parent::__construct($app);
        //留给批量删除使用
        $this->assign('action',$this->request->action());
    }

    public function vipterms(){
        $list = mAbout::where("isdeleted",0)->where('type',2)->find();
        $this->assign("t","会员条款");
        $this->assign("edit_url",url("/about/vipterms_edit"));
        $this->assign("edit_url_params",url("/about/vipterms_edit",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("del_url_params",url("/about/vipterms_del",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("list",$list);
        return view("/admin/about/list");
        
    }
    public function vipterms_edit(int $id=0){
        $list = mAbout::where("isdeleted",0)->where('type',2)->where('id',$id)->find();
        if ($list){
            $this->assign("t","会员条款编辑");
        }else{
            $this->assign("t","会员条款新增");
        }
        $this->assign("save_url",url("/about/vipterms_save"));
        $this->assign("list",$list);
        return view("/admin/about/edit");
    }
    public function vipterms_save(){
        $id = request()->param("id",0,'intval');
        $title = request()->param("title",'');
        $content = request()->param("content",'');
        
        if($id==0){
            $list = new mAbout();
        }else{
            $list = mAbout::where("isdeleted",0)->where('id',$id)->find();
        }
        $list['type'] = 2;
        $list['title'] = $title;
        $list['content'] =$content;
        $list['user_id'] =session('user')['id'];
        $list['current'] =time();
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $list->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $list->current;
                $img['other_id'] = $list->id;
                $img['img_type'] = 6;
                $img->save();
            }
        }
        return '保存成功';
        
    }
    public function vipterms_del(int $id=0){
        $about = mAbout::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($about)){
            $about['isdeleted'] = 1;
            $imgs = Img::where('img_type',6)->where('other_id',$about['id'])->select();
            $rootPath = App::getRootPath();
            
            for($n=0;$n<count($imgs);$n++){
                if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                    unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
                }
                Img::destroy($imgs[$n]['id']);
            }
            $about->save();
        }
        $this->success("删除成功",url('/about/vipterms'));
    }
    
    public function agreement(){
        $list = mAbout::where("isdeleted",0)->where('type',1)->find();
        $this->assign("edit_url_params",url("/about/agreement_edit",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("del_url_params",url("/about/agreement_del",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("edit_url",url("/about/agreement_edit"));
        $this->assign("t","用户协议");
        $this->assign("list",$list);
        return view("/admin/about/list");
    }
    public function agreement_edit(int $id=0){
        $list = mAbout::where("isdeleted",0)->where('type',1)->where('id',$id)->find();
        if ($list){
            $this->assign("t","用户协议编辑");
        }else{
            $this->assign("t","用户协议新增");
        }
        $this->assign("save_url",url("/about/agreement_save"));
        $this->assign("list",$list);
        return view("/admin/about/edit");
    }
    public function agreement_save(){
        $id = request()->param("id",0,'intval');
        $title = request()->param("title",'');
        $content = request()->param("content",'');
        
        if($id==0){
            $list = new mAbout();
        }else{
            $list = mAbout::where("isdeleted",0)->where('id',$id)->find();
        }
        $list['type'] = 1;
        $list['title'] = $title;
        $list['content'] =$content;
        $list['user_id'] =session('user')['id'];
        $list['current'] =time();
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $list->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $list->current;
                $img['other_id'] = $list->id;
                $img['img_type'] = 6;
                $img->save();
            }
        }
        return '保存成功';
    }
    public function agreement_del(int $id=0){
        $about = mAbout::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($about)){
            $about['isdeleted'] = 1;
            $imgs = Img::where('img_type',6)->where('other_id',$about['id'])->select();
            $rootPath = App::getRootPath();
            
            for($n=0;$n<count($imgs);$n++){
                if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                    unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
                }
                Img::destroy($imgs[$n]['id']);
            }
            $about->save();
        }
        $this->success("删除成功",url('/about/agreement'));
    }
    
    
    public function us(){
        $list = mAbout::where("isdeleted",0)->where('type',0)->find();
        $this->assign("edit_url_params",url("/about/us_edit",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("del_url_params",url("/about/us_del",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("edit_url",url("/about/us_edit"));
        $this->assign("t","关于我们");
        $this->assign("list",$list);
        return view("/admin/about/list");
    }
    public function us_edit(int $id=0){
        $list = mAbout::where("isdeleted",0)->where('type',0)->where('id',$id)->find();
        if ($list){
            $this->assign("t","关于我们编辑");
        }else{
            $this->assign("t","关于我们新增");
        }
        $this->assign("save_url",url("/about/us_save"));
        $this->assign("list",$list);
        return view("/admin/about/edit");
    }
    public function us_save(){
        $id = request()->param("id",0,'intval');
        $title = request()->param("title",'');
        $content = request()->param("content",'');
        
        if($id==0){
            $list = new mAbout();
        }else{
            $list = mAbout::where("isdeleted",0)->where('id',$id)->find();
        }
        $list['type'] = 0;
        $list['title'] = $title;
        $list['content'] =$content;
        $list['user_id'] =session('user')['id'];
        $list['current'] =time();
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $list->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $list->current;
                $img['other_id'] = $list->id;
                $img['img_type'] = 6;
                $img->save();
            }
        }
        return '保存成功';
    }
    public function us_del(int $id=0){
        $about = mAbout::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($about)){
            $about['isdeleted'] = 1;
            $imgs = Img::where('img_type',6)->where('other_id',$about['id'])->select();
            $rootPath = App::getRootPath();
            
            for($n=0;$n<count($imgs);$n++){
                if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                    unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
                }
                Img::destroy($imgs[$n]['id']);
            }
            $about->save();
        }
        $this->success("删除成功",url('/about/us'));
    }
    
    
    
    public function contact(){
        $list = mAbout::where("isdeleted",0)->where('type',3)->find();
        $this->assign("edit_url_params",url("/about/contact_edit",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("del_url_params",url("/about/contact_del",array('id'=>empty($list)?'0':$list['id'])));
        $this->assign("edit_url",url("/about/contact_edit"));
        $this->assign("t","联系我们");
        $this->assign("list",$list);
        return view("/admin/about/list");
    }
    public function contact_edit(int $id=0){
        $list = mAbout::where("isdeleted",0)->where('type',3)->where('id',$id)->find();
        if ($list){
            $this->assign("t","联系我们编辑");
        }else{
            $this->assign("t","联系我们新增");
        }
        $this->assign("save_url",url("/about/contact_save"));
        $this->assign("list",$list);
        return view("/admin/about/edit");
    }
    public function contact_save(){
        $id = request()->param("id",0,'intval');
        $title = request()->param("title",'');
        $content = request()->param("content",'');
        
        if($id==0){
            $list = new mAbout();
        }else{
            $list = mAbout::where("isdeleted",0)->where('id',$id)->find();
        }
        $list['type'] = 3;
        $list['title'] = $title;
        $list['content'] =$content;
        $list['user_id'] =session('user')['id'];
        $list['current'] =time();
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $list->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $list->current;
                $img['other_id'] = $list->id;
                $img['img_type'] = 6;
                $img->save();
            }
        }
        return '保存成功';
    }
    
    public function contact_del(int $id=0){
        $about = mAbout::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($about)){
            $about['isdeleted'] = 1;
            $imgs = Img::where('img_type',6)->where('other_id',$about['id'])->select();
            $rootPath = App::getRootPath();
            
            for($n=0;$n<count($imgs);$n++){
                if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                    unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
                }
                Img::destroy($imgs[$n]['id']);
            }
            $about->save();
        }
        $this->success("删除成功",url('/about/contact'));
    }
}