<?php
namespace app\news\controller;

use app\common\controller\Base;
use app\news\model\News as m_news;
use app\common\model\Img;

class News extends Base
{
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function list(){
        $pageSize = 5;
        $web_type = config('app.web_type');
        $news_list = m_news::where('isdeleted',0)->where('packs','like',"%{$web_type}%")->order('current','desc')->paginate($pageSize);

        $pattern = '/\[\d+\]/';
        $matches = array();
        for($m = 0;$m < count($news_list);$m++){
            preg_match_all($pattern, $news_list[$m]['news_content'], $matches);
            $news_list[$m]['news_content_imgs'] = $matches[0];
            for($n=0;$n<count($matches[0]);$n++){
                $img_id = str_replace("[","",$matches[0][$n]);
                $img_id = str_replace("]","",$img_id);
                $img = Img::get(intval($img_id));
                $news_list[$m]['news_content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$news_list[$m]['news_content']);
            }
            $str = htmlspecialchars_decode($news_list[$m]['news_content']);
            preg_match("/<p>(.+?)<\/p>/", $str, $match);
            if(count($match)>0){
                $news_list[$m]['news_content_str'] = $match[1];
            }else{
                $news_list[$m]['news_content_str'] = '<p></p>';
            }
            
        }
        $page = input('page',1,'intval');
        $count = $news_list->total();
        
        $page_num = $count%$pageSize==0?$count/$pageSize:intval(($count/$pageSize)+1);
        $first = $page>1?$page-1:'false';
        $second = $page<$page_num?$page+1:'false';
        
        $this->assign('url',$this->url);
        if(($page<1||$page>$page_num)&&$count>0){
            return view("/home/public/error");
        }
        
        $this->assign('first',$first);
        $this->assign('second',$second);
        $this->assign('news_list',$news_list);
        return view("/home/news/list");
    }
    public function detail($id=0){
        
        $news = new m_news();
        $news = $news->get_by_id($id);
        $this->assign('url',$this->url);
        if(empty($news)){
            return view("/home/public/error");
        }
        $this->assign('news',$news);
        return view("/home/news/detail");
    }
}