# 同一个页面创建多个编辑器

wangEditor 支持一个页面创建多个编辑器

## 代码示例

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>wangEditor 一个页面多个编辑器</title>
    <style type="text/css">
        .toolbar {
            background-color: #f1f1f1;
            border: 1px solid #ccc;
        }
        .text {
            border: 1px solid #ccc;
            height: 200px;
        }
    </style>
</head>
<body>
    <div id="div1" class="toolbar">
    </div>
    <div style="padding: 5px 0; color: #ccc">中间隔离带</div>
    <div id="div2" class="text">
        <p>第一个 demo（菜单和编辑器区域分开）</p>
    </div>

    <div id="div3">
        <p>第二个 demo（常规）</p>
    </div>

    <!-- 引用js -->
    <script type="text/javascript" src="/wangEditor.min.js"></script>
    <script type="text/javascript">
        var E = window.wangEditor

        var editor1 = new E('#div1', '#div2')
        editor1.create()

        var editor2 = new E('#div3')
        editor2.create()
    </script>
</body>
</html>
```

