<?php
namespace app\common\controller;


use app\admin\model\HomeConfig;

class Base extends Error
{
    public $url = "";
    public $logo_url = "";
    public $other_logo_url = "";
    public $vedio_url = "";
    public $host_name = "";
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function initialize(){
        $this->url = request()->controller();
        $this->host_name = request()->domain();
        $other_logo = $this->getImage(4);
        $index_logo = $this->getImage(5);
        $vedio = HomeConfig::where("home_config_cate_id",1)->where("isdeleted",0)->Order("current","desc")->find();
        if(!empty($vedio)){
            $this->vedio_url = $vedio->img->img_url.$vedio->img->img_name;
        }
        $this->getNav();
        $this->assign("other_logo_url",$other_logo);
        $this->assign("logo_url",$index_logo);
        $this->assign("vedio_url",$this->vedio_url);
        $this->assign("host_name",$this->host_name);
    }

    public function getImage($type){
        //获取首页背景图
        $bannerImgId = db('advertisement')->where(array('type'=>$type,'is_display'=>1))->field('id,mintype,packs')->select();
        $bannerImgId = $this->dealData($bannerImgId);
        $data = [];
        foreach ($bannerImgId as $k=>$v){
            $data = $this->getList($v);
        }
        return $data;
    }

    public function getList($data){
        $where[] = ['starttime','<',time()];
        $where[] = ['endtime','>',time()];
        $where[] = ['starthour','<',date('h',time())];
        $where[] = ['endhour','>',date('h',time())];
        $cont = db('advertisement_cont')
            ->where($where)
            ->where(array('advert_id'=>$data['id']))
            ->field('picSrc,packs')
            ->order('orderby desc')
            ->select();
        $cont = $this->dealData($cont);
        $imagePre = "https://oss.3yakj.com/application_static_data";
        $bannerImg = [];
        if ($data['mintype'] == 0){
            if (!empty($cont)){
                $bannerImg = $imagePre.$cont[0]['picSrc'];
            }else{
                $bannerImg = '';
            }
        }else{
            foreach ($cont as $value){
                $bannerImg[] = $imagePre.$value['picSrc'];
            }
        }
        return $bannerImg;
    }

    public function getNav(){
        $nav = db('menu')->where(array('status'=>1))->field('id,title,url,show_type,packs')->order('order desc')->select();
        $nav = $this->dealData($nav);
        foreach ($nav as $key=>$value){
            if (!empty($value['url'])){
                $class = explode('.html',$value['url'])[0];
                if ($class !== '/'){
                    $nav[$key]['class'] = explode('/',$class)[1];
                    if ($nav[$key]['class'] == 'index'){
                        $nav[$key]['class'] = 'home';
                    }
                }else{
                    $nav[$key]['class'] = 'home';
                }
            }else{
                $nav[$key]['class'] = '';
            }
            $child = db('menu_child')->where(array('pid'=>$value['id'],'status'=>1))->field('title,show_type,url,packs')->order('order desc')->select();
            $nav[$key]['child'] = $this->dealData($child);
        }
        $this->assign('nav',$nav);
    }

    /**
     * 处理域名数据
     * @param $data
     * @param $type 0：一维数组，1 二维数据
     * @return array
     */
    public function dealData($data,$type = 1){
        $web_type = config('app.web_type');
        $return = [];
        if ($type){
            foreach ($data as $value){
                if (!empty($value['packs'])){
                    if (in_array($web_type,json_decode($value['packs'],true))){
                        $return[] = $value;
                    }
                }
            }
        }else{
            if (!empty($data['packs'])){
                if (in_array($web_type,json_decode($data['packs'],true))){
                    $return = $data;
                }
            }
        }
        return $return;
    }
}