<?php
namespace app\admin\controller;


use app\join\model\Join as mJoin;
use app\common\model\Img;
use think\facade\App;
use app\join\model\JoinCate;

class Join extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize = 10;
        $join_list = mJoin::where('isdeleted',0)->order('current','desc')->paginate($pageSize);
        $this->assign('join_list',$join_list);
        return view("/admin/join/list");
    }
    public function edit(int $id=0){
        $join = mJoin::where('isdeleted',0)->where('id',$id)->find();
        $join_cate_list = JoinCate::where('isdeleted',0)->order('current','desc')->select();
        $this->assign('join_cate_list',$join_cate_list);
        $this->assign('join',$join);
        return view("/admin/join/edit");
    }
    
    
    public function del(int $id){
        $m = mJoin::where('id',$id)->find();
        $m['isdeleted'] = 1;
        $m->save();
        $imgs = Img::where('img_type',5)->where('other_id',$m['id'])->select();
        $rootPath = App::getRootPath();
        
        for($n=0;$n<count($imgs);$n++){
            if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
            }
            Img::destroy($imgs[$n]['id']);
        }
        $this->success("删除成功",url('/join/list'));
    }
    public function save(){
        $id = request()->param('id',0,'intval');
        $content = request()->param('content','');
        $join_cate_id = request()->param('join_cate_id',0);
        $title = request()->param('title','');
        $place = request()->param('place','');
        $join = mJoin::where("isdeleted",0)->where('id',$id)->find();
        if(empty($join)){
            $join = new mJoin();
        }
        $join['title'] = $title;
        $join['place'] = $place;
        $join['content'] = $content;
        $join['user_id'] = session('user')['id'];
        $join['current'] = time();
        if($id==0){
            $join['isdeleted'] = 0;
            $join['isrelease'] = 0;
        }
        $join['join_cate_id'] = $join_cate_id;
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $join->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $join->current;
                $img['other_id'] = $join->id;
                $img['img_type'] = 5;
                $img->save();
            }
        }
        return '保存成功';
    }
}