<?php
namespace app\admin\controller;


use app\servicehelp\model\Question as mQuestion;
use app\servicehelp\model\QuestionCate;
use app\common\model\Img;
use think\facade\App;

class Question extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize = 10;
        $question_list = mQuestion::where('isdeleted',0)->order('current','desc')->paginate($pageSize);
        $this->assign('question_list',$question_list);
        return view("/admin/question/list");
    }
    public function edit(int $id =0){
        $question = mQuestion::where('isdeleted',0)->where('id',$id)->find();
        
        $question_cate_list = QuestionCate::where('isdeleted',0)->order('current','desc')->select();
        $this->assign('question_cate_list',$question_cate_list);
        $this->assign('question',$question);
        return view("/admin/question/edit");
    }
    public function del(int $id=0){
        $question = mQuestion::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($question)){
            $question['isdeleted'] = 1;
            $imgs = Img::where('img_type',4)->where('other_id',$question['id'])->select();
            $rootPath = App::getRootPath();
            
            for($n=0;$n<count($imgs);$n++){
                if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
                    unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
                }
                Img::destroy($imgs[$n]['id']);
            }
            $question->save();
        }
        $this->success("删除成功",url('/question/list'));
    }
    public function save(){
        $id = request()->param('id',0,'intval');
        $content = request()->param('content','');
        $question_cate_id = request()->param('question_cate_id',0);
        $title = request()->param('title','');
        $question = mQuestion::where("isdeleted",0)->where('id',$id)->find();
        if(empty($question)){
            $question = new mQuestion();
        }
        $question['title'] = $title;
        $question['content'] = $content;
        $question['user_id'] = session('user')['id'];
        $question['current'] = time();
        $question['isdeleted'] = 0;
        $question['question_cate_id'] = $question_cate_id;
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $question->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $question->current;
                $img['other_id'] = $question->id;
                $img['img_type'] = 4;
                $img->save();
            }
        }
        return '保存成功';
    }
}