<?php
namespace app\common\controller;


use app\admin\model\HomeConfig;

class Base extends Error
{
    public $url = "";
    public $logo_url = "";
    public $other_logo_url = "";
    public $vedio_url = "";
    public $host_name = "";
    public function _empty($method)
    {
        return view("/home/public/error");
    }
    
    public function initialize(){
        $this->url = request()->controller();
        $this->host_name = request()->domain();
        $other_logo = HomeConfig::where("home_config_cate_id",3)->where("isdeleted",0)->Order("current","desc")->find();
        $index_logo = HomeConfig::where("home_config_cate_id",2)->where("isdeleted",0)->Order("current","desc")->find();
        $vedio = HomeConfig::where("home_config_cate_id",1)->where("isdeleted",0)->Order("current","desc")->find();
        if(!empty($index_logo)){
            $this->logo_url = $index_logo->img->img_url.$index_logo->img->img_name;
        }
        if(!empty($other_logo)){
            $this->other_logo_url = $other_logo->img->img_url.$other_logo->img->img_name;
        }
        if(!empty($vedio)){
            $this->vedio_url = $vedio->img->img_url.$vedio->img->img_name;
        }
        $this->assign("other_logo_url",$this->other_logo_url);
        $this->assign("logo_url",$this->logo_url);
        $this->assign("vedio_url",$this->vedio_url);
        $this->assign("host_name",$this->host_name);
    }
}