<?php
namespace app\admin\validate;

use think\Validate;

class User extends Validate
{
    protected $rule = [
        'username'  =>  'require|max:25',
        'password' =>  'require|min:25',
    ];
    
    protected $message = [
        'username.require'  =>  '用户名必须',
        'password.require' =>  '密码必须',
    ];
    
    protected $scene = [
        'add'   =>  ['username','password'],
        'login'  =>  ['username','password'],
    ];
}