<?php
namespace app\news\model;

use app\common\model\Img;
use think\Model;

class News extends Model
{
    public function get_by_id(int $id){
        $news = $this->where('id',$id)->where('isdeleted',0)->find();
        if(empty($news)){
            return false;
        }
        $matches = array();
        $pattern = '/\[\d+\]/';
        preg_match_all($pattern, $news['news_content'], $matches);
        $news['news_content_imgs'] = $matches[0];
        $news['news_content'] = str_replace('新秀娱乐','朱贝',$news['news_content']);
        for($n=0;$n<count($matches[0]);$n++){
            $img_id = str_replace("[","",$matches[0][$n]);
            $img_id = str_replace("]","",$img_id);
            $img = Img::get(intval($img_id));
            $news['news_content'] = str_replace($matches[0][$n],$img['img_url'].$img['img_name'],$news['news_content']);
        }
        return $news;
    }
    public function user()
    {
        return $this->hasOne('app\admin\model\Users','id','user_id');
    }
}