<?php
namespace app\admin\controller;



use app\admin\model\App;
use app\admin\model\AppCate;
use app\common\model\Img;
use think\Exception;

class AppManage extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize =10 ;
        $app_list = App::where("isdeleted",0)->paginate($pageSize);
        $this->assign("app_list",$app_list);
        return view("/admin/app_manage/list");
    }
    public function edit(int $id=0){
        $app_cate_list = AppCate::where("isdeleted",0)->select();
        $app = App::where("isdeleted",0)->where('id',$id)->find();
        $this->assign("app",$app);
        $this->assign("app_cate_list",$app_cate_list);
        return view("/admin/app_manage/edit");
    }
    public function save(){
        //1.获取职位类别
        $id = request()->param('id',0,'intval');
        
        try {
            if($id==0){
                $app = new App();
                $app['title'] = trim(request()->param('name'));
                $app['app_cate_id'] = request()->param('app_cate_id');
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $app['file_link'] = request()->param('file_link');
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不正确');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 8;
                $img['current'] = time();
                $img->save();
                $app['img_id'] = $img->id;
                $app->save();
            }else{
                $app = App::where('isdeleted',0)->where('id',$id)->find();
                if(empty($app)){
                    $this->error("该项已被删除");
                }
                $is_cover = request()->param('is_cover');
                if(strtolower($is_cover)=="on"){
                    $img = new Img();
                    $file = request()->file('img');
                    $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                    if (!$info){
                        $this->error('图片太大或格式不正确');
                    }
                    $img['img_name'] =   $info->getSaveName();
                    $img_url = "/uploads/static_data/";
                    $img_url_array = explode("/",$info->getExtension());
                    $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                    $img['img_url'] = $img_url;
                    $img['img_type'] = 2;
                    $img['current'] = time();
                    $img->save();
                    $temp_img = Img::get($app['img_id']);
                    unlink("../public".$temp_img["img_url"].$temp_img['img_name']);
                    Img::destroy($app['img_id']);
                    $app['img_id'] = $img->id;
                }
                $app['app_cate_id'] = request()->param('app_cate_id');
                $app['title'] = trim(request()->param('name'));
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $app['file_link'] = request()->param('file_link');
                $app->save();
            }
        } catch (Exception $e) {
            
            // unlink('../public/uploads/static_data/'.$info->getExtension());
        }
        $this->redirect(url("/app_manage/list"));
    }
}