<?php
namespace app\admin\controller;

use app\common\controller\Error;
use think\App;
use think\facade\Config;

class AdminBase extends Error
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }

    public function __construct(App $app = null)
    {
        parent::__construct($app);
        $this->fromDelAll = false;
    }

    public function initialize(){
            $start_time = session('session_start_time');
            $expire = Config::get('session.expire');
            $token =  session('token');
            if(time()-$start_time>$expire){
                session(null);
            }
            if(empty($token)){
                $this->redirect(url("/fanjiao_login"));
            }
            session('session_start_time',time());
    }

    //批量删除
    public function delAll(string $ids='',string $action=''){

        if (empty($ids)){
            $this->error('请选择要删除的项！');
        }
        $idArr = explode(',',$ids);
        //about页面的删除方法不一样 恶心人
//        $methods = array(
//            'del',
//            'vipterms_del', //会员条款
//            'agreement_del', //用户协议
//            'us_del', //关于我们
//            'contact_del', //联系我们
//        );
        //用这个先跳出success的成功跳转
        $this->fromDelAll = true;
        //暂时加不了事务
        foreach ($idArr as $v){
            if (method_exists($this,$action.'del')){
                $self_del = $action.'del';
                $this->$self_del($v);
            }
        }
        $this->fromDelAll = false;
        $this->success('删除成功！');
    }
}
