<?php
namespace app\admin\controller;



use app\common\model\Img;
use app\admin\model\Game as mGame;
use app\admin\model\GameCate;
use think\Exception;

class Game extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize =10 ;
        $app_list = mGame::where("isdeleted",0)->paginate($pageSize);
        $this->assign("game_list",$app_list);
        return view("/admin/game_manage/list");
    }
    public function edit(int $id=0){
        $app_cate_list = GameCate::where("isdeleted",0)->select();
        $app = mGame::where("isdeleted",0)->where('id',$id)->find();
        $this->assign("game",$app);
        $this->assign("game_cate_list",$app_cate_list);
        return view("/admin/game_manage/edit");
    }
    public function save(){
        //1.获取职位类别
        $id = request()->param('id',0,'intval');
        
        try {
            if($id==0){
                $app = new mGame();
                $app['title'] = trim(request()->param('name'));
                $app['game_cate_id'] = request()->param('game_cate_id');
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $file_link =  request()->param('file_link');
                if(!strstr($file_link, 'http://')||!strstr($file_link, 'https://')){
                    $file_link ="http://".$file_link;
                }
                $app['file_link'] =$file_link;
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->validate(['size'=>1024000,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不正确');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 8;
                $img['current'] = time();
                $img->save();
                $app['img_id'] = $img->id;
                $app->save();
            }else{
                $app = mGame::where('isdeleted',0)->where('id',$id)->find();
                if(empty($app)){
                    $this->error("该项已被删除");
                }
                $is_cover = request()->param('is_cover');
                if(strtolower($is_cover)=="on"){
                    $img = new Img();
                    $file = request()->file('img');
                    $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                    if (!$info){
                        $this->error('图片太大或格式不正确');
                    }
                    $img['img_name'] =   $info->getSaveName();
                    $img_url = "/uploads/static_data/";
                    $img_url_array = explode("/",$info->getExtension());
                    $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                    $img['img_url'] = $img_url;
                    $img['img_type'] = 13;
                    $img['current'] = time();
                    $img->save();
                    $temp_img = Img::get($app['img_id']);
                    unlink("../public".$temp_img["img_url"].$temp_img['img_name']);
                    Img::destroy($app['img_id']);
                    $app['img_id'] = $img->id;
                }
                $app['game_cate_id'] = request()->param('game_cate_id');
                $app['title'] = trim(request()->param('name'));
                $app['user_id'] = session('user')['id'];
                $app['current'] = time();
                $app['isdeleted'] = 0;
                $file_link =  request()->param('file_link');
                if(!strstr($file_link, 'http://')||!strstr($file_link, 'https://')){
                    $file_link ="http://".$file_link;
                }
                $app['file_link'] =$file_link;
                $app->save();
            }
        } catch (Exception $e) {
            
            // unlink('../public/uploads/static_data/'.$info->getExtension());
        }
        $this->redirect(url("/game_manage/list"));
    }
    public function del(int $id=0){
    }
}