<?php
namespace app\admin\controller;


use app\news\model\News as mNews;
use think\facade\App;
use app\common\model\Img;

class News extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize = 5;
        $news_list = mNews::where('isdeleted',0)->order('current','desc')->paginate($pageSize);
        $this->assign('news_list',$news_list);
        return view("/admin/news/list");
    }
    public function edit(int $id=0){
        $news = mNews::where('isdeleted',0)->where('id',$id)->find();
        $this->assign('news',$news);
        return view("/admin/news/edit");
    }
    public function del(int $id=0){
        $m = mNews::where('isdeleted',0)->where('id',$id)->find();
        $m['isdeleted'] = 1;
        $m->save();
        $imgs = Img::where('img_type',1)->where('other_id',$m['id'])->select();
        $rootPath = App::getRootPath();

        for($n=0;$n<count($imgs);$n++){
//            if(file_exists($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name'])){
//                unlink($rootPath.'/public/'.$imgs[$n]['img_url'].$imgs[$n]['img_name']);
//            }
            Img::destroy($imgs[$n]['id']);
        }
        
        $this->success("删除成功",url('/news/list'));
    }
    public function save(){
        $id = request()->param('id',0,'intval');
        $content = request()->param('content','');
        $title = request()->param('title','');
        $news = mNews::where("isdeleted",0)->where('id',$id)->find();
        if(empty($news)){
            $news = new mNews();
        }
        $news['news_title'] = $title;
        $news['news_content'] = $content;
        $news['user_id'] = session('user')['id'];
        $news['current'] = time();
        if($id==0){
            $news['isdeleted'] = 0;
        }
        $pattern = "/<[img|IMG].*?src=['|\"](.*?(?:[.gif|.jpg|.png]))['|\"].*?[\/]?>/";
        $matches = array();
        preg_match_all($pattern, $content, $matches);
        $news->save();
        if(count($matches)>1){
            for($n=0;$n<count($matches[count($matches)-1]);$n++){
                $img = new Img();
                $img_name = $matches[count($matches)-1][$n];
                $img_name = str_replace("/uploads/static_data/", "", $img_name);
                //2020 09 08 不知道下面这行要做什么
//                $img = $img->find($img_name, "/uploads/static_data/");
                $img['content_release'] = $news->current;
                $img['other_id'] = $news->id;
                $img['img_type'] = 1;
                $img->save();
            }
        }
        return '保存成功';
    }
}