<?php
namespace app\admin\controller;


use think\Exception;
use app\common\model\Img;
use app\admin\model\GameCate as mGameCate;
class GameCate extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }
    
    
    public function list(){
        $pageSize = 10;
        $app_cate_list = mGameCate::where('isdeleted',0)->paginate($pageSize);
        $this->assign('game_cate_list',$app_cate_list);
        return view("/admin/game_manage/cate_list");
    }
    public function edit(int $id=0){
        $app_cate = mGameCate::where('isdeleted',0)->where('id',$id)->find();
        $this->assign('game_cate',$app_cate);
        return view("/admin/game_manage/cate_edit");
    }
    public function save(){
        
        //1.获取职位类别
        $id = request()->param('id',0,'intval');
        
        try {
            if($id==0){
                $appCate = new mGameCate();
                $appCate['title'] = trim(request()->param('name'));
                $appCate['user_id'] = session('user')['id'];
                $appCate['current'] = time();
                $appCate['isdeleted'] = 0;
                
                $img = new Img();
                $file = request()->file('img');
                $info = $file->validate(['size'=>102400,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不正确');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 12;
                $img['current'] = time();
                $img->save();
                $appCate['img_id'] = $img->id;
                $appCate->save();
            }else{
                $appCate = mGameCate::where('isdeleted',0)->where('id',$id)->find();
                if(empty($appCate)){
                    $this->error("该分类已被删除");
                }
                $appCate['title'] = trim(request()->param('name'));
                $appCate['user_id'] = session('user')['id'];
                $appCate['current'] = time();
                $appCate['isdeleted'] = 0;
                $appCate->save();
            }
        } catch (Exception $e) {
            unlink('../public/uploads/static_data/'.$info->getExtension());
        }
        $this->redirect(url("/gameCate/cate_list"));
    }
    public function del(int $id=0){
        $join_cate = mGameCate::where("isdeleted",0)->where('id',$id)->find();
        if(!empty($join_cate)){
            $join_cate['isdeleted'] = 1;
            $join_cate->save();
        }
        $this->redirect(url("/gameCate/cate_list"));
    }
}