<?php
namespace app\admin\controller;
use app\admin\model\HomeConfigCate;
use app\common\model\Img;
use think\Exception;
use think\facade\App;
class Banner extends AdminBase
{
    public function _empty($method)
    {
        $this->assign('url','d');
        return view("/home/public/error");
    }


    public function list(){
        $pageSize = 10;
        $banner_list = db('banner')->where('isdeleted',0)->order('created_at','desc')->paginate($pageSize);
        $this->assign('banner_list',$banner_list);
        return view("/admin/banner/list");
    }

    public function edit(int $id=0){
        $banner =db('banner')->where('isdeleted',0)->where('id',$id)->find();
        $this->assign('banner',$banner);
        return view("/admin/banner/edit");
    }


    public function del(int $id){
        $data = db('banner')->where('id',$id)->find();
        if ($data){
            db('banner')->where('id',$id)->update(['isdeleted'=>1]);
            $this->success("删除成功",url('/banner/list'));
        }else{
            $this->error('Banner不存在');
        }
    }
    public function save(){
        $id = request()->param('id',0,'intval');
        try {
            if($id==0){
                $insert = array();
                $insert['name'] = trim(request()->param('name'));
                $insert['config_address'] = trim(request()->param('config_address'));
                $insert['user_id'] = session('user')['id'];
                $insert['created_at'] = time();
                $insert['isdeleted'] = 0;

                $img = new Img();
                $file = request()->file('icon');
                $info = $file->validate(['size'=>2048000,'ext'=>'jpg,png,gif'])->rule('uniqid')->move( '../public/uploads/static_data/');
                if (!$info){
                    $this->error('图片太大或格式不是png');
                }
                $img['img_name'] =   $info->getSaveName();
                $img_url = "/uploads/static_data/";
                $img_url_array = explode("/",$info->getExtension());
                $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                $img['img_url'] = $img_url;
                $img['img_type'] = 12;//banner图
                $img['current'] = time();
                $img->save();

                $insert['icon'] = $img->img_url.$img->img_name;
                db('banner')->insert($insert);
            }else{
                $app = db('banner')->where('isdeleted',0)->where('id',$id)->find();
                if(empty($app)){
                    $this->error("该项已被删除");
                }
                $is_cover = request()->param('is_cover');
                if(strtolower($is_cover)=="on"){
                    $img = new Img();
                    $file = request()->file('icon');
                    $info = $file->validate(['size'=>102400,'ext'=>'png'])->rule('uniqid')->move( '../public/uploads/static_data/');
                    if (!$info){
                        $this->error('图片太大或格式不是png');
                    }
                    $img['img_name'] =   $info->getSaveName();
                    $img_url = "/uploads/static_data/";
                    $img_url_array = explode("/",$info->getExtension());
                    $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
                    $img['img_url'] = $img_url;
                    $img['img_type'] = 2;
                    $img['current'] = time();
                    $img->save();
//                    $temp_img = Img::get($joinCate['img_id']);
//                    unlink("../public".$temp_img["img_url"].$temp_img['img_name']);
//                    Img::destroy($joinCate['img_id']);
                    $update['icon'] = $img->img_url.$img->img_name;
                }

                $update['name'] = trim(request()->param('name'));
                $update['config_address'] = trim(request()->param('config_address'));
                $update['user_id'] = session('user')['id'];
                $update['created_at'] = time();
                $update['isdeleted'] = 0;
                $update['id']=$id;
                db('banner')->update($update);
            }
        } catch (Exception $e) {
            unlink('../public/uploads/static_data/'.$info->getExtension());
        }

        $this->success('操作成功',url("/banner/list"));
    }
}