<?php
namespace app\admin\controller;


use app\common\model\Img;
use think\Controller;

class Uploads extends Controller
{
    public $fromDelAll = false;
    public function uploads(){
        $img = new Img();
        $file = request()->file('img');
        $info = $file->validate(['size'=>20480000,'ext'=>'jpg,png,gif,apk,mp4'])->rule('uniqid')->move( '../public/uploads/static_data/');
        if (!$info){
            $this->error('图片太大或格式不正确');
        }
        $img['img_name'] =   $info->getSaveName();
        $img_url = "/uploads/static_data/";
        $img_url_array = explode("/",$info->getExtension());
        $img_url .= str_replace($img_url_array[count($img_url_array)-1],"",$info->getExtension());
        $img['img_url'] = $img_url;
        $img['current'] = time();
        $img->save();
        $array = array('errno'=>0,'data'=>array($img_url.$info->getSaveName()));
        return   json($array);
    }

    public function getConfig(){
        //获取首页背景图
        $bannerImgId = db('home_config')->where('title','首页背景图')->value('img_id');
        $bannerImg = db('img')->where('id',$bannerImgId)->field('img_name,img_url')->find();
        //获取按钮
        $button = db('banner')->where('isdeleted',0)->field('name,icon,config_address')->order('created_at desc')->select();
        return json(['banner'=>$bannerImg['img_url'].$bannerImg['img_name'],'button'=>$button] );
    }
}