import { createApp } from 'vue'
import Captcha from './Captcha.vue'

export interface CaptchaProps {
    /**
     * 获取验证码数据的接口地址
     */
    requestCaptchaDataUrl: string
    /**
     * 校验验证码数据的接口地址
     */
    validCaptchaUrl: string
    /**
     * 是否显示关闭按钮
     */
    showClose?: boolean
    /**
     * 是否显示为圆角
     */
    radius?: boolean
    /**
     * 是否显示阴影
     */
    shadow?: boolean
    /**
     * 显示语言设置，支持zh-CN,zh-TW,en
     */
    locale?: string
    /**
     * 额外的CSS类名
     */
    className?: string
    /**
     * 额外的样式
     */
    style?: Record<string, string | number> | string
    /**
     * 当验证码校验成功时触发的回调
     * @param id 验证码id
     */
    onSuccess?: (id: string) => void
    /**
     * 当用户点击关闭按钮时触发的回调
     */
    onClose?: () => void
}

export interface CaptchaInstance {
    refresh(): void
}

export function createCaptcha(
    container: string | Element,
    options: CaptchaProps,
) {
    const app = createApp(Captcha, {
        ...options,
    })

    const refresh = () => {
        console.log(app)
    }

    app.mount(container)

    return {
        refresh,
    }
}
