import { CaptchaDisplayData } from './types';
/**
 * 创建验证码实例的配置项
 */
interface CreateCaptchaOptions {
    /**
     * 自动绑定开始拖动事件的元素
     */
    triggers?: HTMLElement[];
    /**
     * 验证码显示数据
     */
    captcha: CaptchaDisplayData;
    /**
     * 允许拖动的最大距离
     */
    max: number;
    /**
     * 当进行拖动时触发的回调
     * @param x 拖动的距离
     */
    onDrag: (x: number) => void;
    /**
     * 当拖动完成需要校验数据时触发的回调
     * @param data 待校验的数据
     * @returns
     */
    onVerify: (data: object) => void;
}
/**
 * 验证码实例
 */
export interface CaptchaInstance {
    /**
     * 当开始拖动时调用的方法
     * @param event
     * @returns
     */
    onDragStart: (event: MouseEvent | TouchEvent) => void;
    /**
     * 销毁验证码实例，解除所有的事件绑定
     */
    destroy(): void;
}
/**
 * 创建拖动填充型验证码的配置项
 */
export interface CreateSliderCaptchaOptions extends Omit<CreateCaptchaOptions, 'max'> {
    /**
     * 实际显示尺寸与原始图片的比例
     */
    ratio: number;
}
/**
 * 创建拖动填充型验证码实例
 * @param options
 */
export declare function createSliderCaptcha(options: CreateSliderCaptchaOptions): CaptchaInstance;
/**
 * 创建旋转型验证码的配置项
 */
export interface CreateRotateCaptchaOptions extends Omit<CreateCaptchaOptions, 'onDrag'> {
    /**
     * 实际显示尺寸与原始图片的比例
     */
    ratio: number;
    /**
     * 当进行拖动时触发的回调
     * @param x 拖动的距离
     * @param deg 旋转的角度
     */
    onDrag: (x: number, deg: number) => void;
}
/**
 * 创建旋转型验证码实例
 */
export declare function createRotateCaptcha(options: CreateRotateCaptchaOptions): CaptchaInstance;
/**
 * 创建上下拼接型验证码的配置项
 */
export interface CreateConcatCaptchaOptions extends CreateCaptchaOptions {
    /**
     * 实际显示尺寸与原始图片的比例
     */
    ratio: number;
}
/**
 * 获取上下拼接型验证码的滑块高度
 */
export declare function getConcatTrackHeight(captcha: CaptchaDisplayData, ratio: number): number;
/**
 * 创建上下拼接型验证码实例
 */
export declare function createConcatCaptcha(options: CreateConcatCaptchaOptions): CaptchaInstance;
export {};
