import legacy from '@vitejs/plugin-legacy'
import vue from '@vitejs/plugin-vue'
import { defineConfig } from 'vite'

// https://vitejs.dev/config/
export default defineConfig({
    plugins: [vue(), legacy()],
    server: {
        host: true,
        proxy: {
            '/api/captcha/': {
                target: 'http://localhost:8080',
            },
        },
    },
    build: {
        target: 'es2015',
        cssTarget: 'chrome61',
        rollupOptions: {
            input: {
                index: './index.html',
                live: './live.html',
            },
        },
    },
})
