package com.fanjiao.captcha.server.dto;

import cloud.tianai.captcha.common.response.ApiResponse;
import lombok.Data;

/**
 * 简洁处理后的接口响应体
 *
 * @param <T>
 */
@Data
public class Response<T> {
    private int code = 0;
    private String msg = "success";
    private T data;

    /**
     * 从原始接口响应数据中生成新的响应体
     *
     * @param source 原始接口响应数据
     */
    public static Response<?> from(ApiResponse<?> source) {
        if (source.isSuccess()) {
            return success(source.getData());
        } else {
            return fail(source.getMsg(), source.getCode());
        }
    }

    public static <T> Response<T> success(T data) {
        Response<T> resp = new Response<>();
        resp.setCode(0);
        resp.setMsg("success");
        resp.setData(data);
        return resp;
    }

    public static Response<?> success() {
        return success(null);
    }

    public static Response<?> fail(String msg, int code) {
        Response<?> resp = new Response<>();
        resp.setCode(code);
        resp.setMsg(msg);
        return resp;
    }

    public static Response<?> fail(String msg) {
        return fail(msg, 500);
    }
}
