# 行为验证码服务

## 验证流程

![img](flows.png)

## APP端接入

- 接入前，APP开发者需要准备一个Webview容器用于承载验证码内容，此容器内容区域最小的尺寸为300x400像素。
- 当需要呈现行为验证码时，创建此Webview容器，并根据需要组装`验证页URL`，详细的组装规则参见[验证页URL参数](#验证页URL参数)
- 根据验证页参数，当用户完成行为验证时会通过以下方式之一通知宿主APP
  - URL通知：页面会跳转到以下固定格式的URL`https://captcha.service.briefmsg.cn/success.html?key={验证标识}`，宿主APP可以监听Webview容器的页面跳转事件，当检测到页面URL满足此格式时，从URL中取出验证标识并关闭Webview容器，进行后续操作
  - JS通知：要求宿主APP提前在Webview中注册全局通信函数，并通过验证页URL上的`callback`参数传递此函数名，当用户完成验证时，会调用此全局函数将验证标识传递到宿主APP

### 验证页URL参数

验证页可按如下格式接收参数，满足定制需求

```
https://captcha.service.briefmsg.cn/?lang=xxxx&bg=%23ff0000&shadow=1&radius=1&extra=xxxxx&callback=xxxxx
```

| 参数名   | 参数说明                                                                                                                                                                                                                                                                                                                                         |
| -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| lang     | 显示语言，可选值为`zh-TW`,`zh-CN`,`en`。如果不传则自动根据当前浏览器环境判断                                                                                                                                                                                                                                                                     |
| bg       | 验证框容器的背景色，不传默认为白色。如果传入值需做URL参数转码，比如想用`#ff0000`，则转码后应为`%23ff0000`                                                                                                                                                                                                                                        |
| shadow   | 是否在验证框容器下显示阴影，0-无阴影 1-有阴影，不传默认为0                                                                                                                                                                                                                                                                                       |
| radius   | 验证框容器圆角半径，单位像素，不传默认为0                                                                                                                                                                                                                                                                                                        |
| extra    | 额外的验证参数，可以根据使用场景传入比如手机号、IP地址等等其他数据，在后续服务端验证时，可对这些数据进行二次验证。此参数的值一个转化为对象后的JSON字符串。例如需要校验手机号和ip数据：`{"mobile":"13812345678","ip":"127.0.0.1"}`，进行JSON和URL转码后，实际在URL中为`extra=%7B%22mobile%22%3A%2213812345678%22%2C%22ip%22%3A%22127.0.0.1%22%7D` |
| callback | 当个用户验证成功后的回调函数名，如果不传则通过跳转地址的方式回传验证标识数据                                                                                                                                                                                                                                                                     |

## H5接入

### VUE3

1. 引入npm库

```shell
npm i git+http://gitlab.3yakj.com/crystalray/fj-captcha-service.git/vue
```

## 服务端接入

当前端收到验证完成事件，收到了验证标识之后，可以传递给服务端，由服务端调用验证服务进行数据校验，校验通过后即可执行自身的业务逻辑。

### 验证方式1：提交验证数据到验证服务

- 接口地址 `https://captcha.service.briefmsg.cn/api/captcha/use`
- 请求方式 `POST`
- 请求数据格式 `JSON`
- 请求参数

```json
{
    "key": "验证标识",
    "extra": {
        //可选的额外验证数据
    }
}
```

| 参数名 | 类型   | 必需 | 参数说明                                                                                      |
| ------ | ------ | ---- | --------------------------------------------------------------------------------------------- |
| key    | string | 是   | 前端获得的验证标识                                                                            |
| extra  | object | 否   | 额外的验证数据，此处的验证数据，应与构建验证页URL时传递的验证数据相同，否则数据将无法校验通过 |

- 接口响应，当code为0时表示验证成功，非0时表示验证失败

```json
{
    "code": 0,
    "msg": "success"
}
```

### 验证方式2：从验证服务获取验证数据

- 验证接口地址 `https://captcha.service.briefmsg.cn/api/captcha/verify`
- 请求方式 `POST`
- 请求数据格式 `JSON`
- 请求参数

```json
{
    "key": "验证标识"
}
```

| 参数名 | 类型   | 必需 | 参数说明           |
| ------ | ------ | ---- | ------------------ |
| key    | string | 是   | 前端获得的验证标识 |

- 接口响应，当code为0时表示验证成功，非0时表示验证失败

```json
{
    "code": 0,
    "msg": "success",
    "data": {
        "ip": "127.0.0.1",
        "extra": {}
    }
}

| 响应字段 | 类型   | 必需 | 参数说明                                                                        |
| -------- | ------ | ---- | ------------------------------------------------------------------------------- |
| ip       | string | 是   | 用户校验时的客户端IP                                                            |
| extra    | object | 是   | 通过验证页URL传递的额外的验证数据，如果验证页没有传额外数据也会返回一个空对象{} |
```