import vue from '@vitejs/plugin-vue'
import { resolve } from 'node:path'
import { defineConfig } from 'vite'

// https://vitejs.dev/config/
export default defineConfig({
    resolve: {
        alias: [
            {
                find: /^fj-captcha-web$/,
                replacement: resolve(__dirname, '../vue/src'),
            },
        ],
    },
    plugins: [vue()],
    server: {
        host: true,
        proxy: {
            '/api/captcha/': {
                target: 'http://localhost:8080',
            },
        },
    },
    build: {
        cssTarget: 'chrome61',
    },
})
