/**
 * 验证码类型
 */
export type CaptchaType = 'SLIDER' | 'ROTATE' | 'CONCAT'

/**
 * 接口响应数据格式
 */
export interface ApiResp<T = any> {
    code: number
    msg: string
    data: T
}

/**
 * 验证码显示数据
 */
export interface CaptchaDisplayData {
    /**
     * 验证码类型
     */
    type: CaptchaType
    templateImage: string
    templateImageHeight: number
    templateImageTag: string
    templateImageWidth: number
    backgroundImage: string
    backgroundImageHeight: number
    backgroundImageTag: string
    backgroundImageWidth: number
    data: {
        randomY: number
    }
}

/**
 * 验证码数据
 */
export interface CaptchaData {
    key: string
    captcha: CaptchaDisplayData
}
