import { InjectionKey, Ref, computed, inject, provide } from 'vue'
import { getTranslator } from './core'

const KEY_LOCALE: InjectionKey<Ref<string | undefined>> = Symbol()

export function provideLocale(ref: Ref<string | undefined>) {
    provide(KEY_LOCALE, ref)
}

export function useTranslator(locale?: Ref<string | undefined>) {
    if (!locale) {
        locale = inject(KEY_LOCALE, () => computed(() => undefined), true)
    }
    return computed(() => getTranslator(locale.value))
}
