import { ApiResp, CaptchaData } from './types';
/**
 * HTTP请求配置项
 */
export interface HttpRequestOptions {
    /**
     * 请求地址
     */
    url: string;
    /**
     * 基地址
     */
    baseURL?: string;
    /**
     * 请求方法
     */
    method?: string;
    /**
     * 请求参数
     */
    params?: Record<string, string>;
    /**
     * 请求头
     */
    headers?: Record<string, string>;
    /**
     * 请求体
     */
    data?: any;
    /**
     * 请求超时时间
     */
    timeout?: number;
    /**
     * 跨域时是否包含身份信息
     */
    withCredentials?: boolean;
}
export interface HttpResponse<T = any> {
    /**
     * 响应码
     */
    status: number;
    /**
     * 响应头
     */
    headers: Record<string, string>;
    /**
     * 响应体
     */
    data: T;
}
/**
 * 加载验证码数据
 * @param options 获取验证码数据的配置项
 */
export declare function loadCaptcha(options: HttpRequestOptions): Promise<ApiResp<CaptchaData>>;
export interface ValidCaptchaOptions extends Omit<HttpRequestOptions, 'method' | 'data'> {
    data: {
        key: string;
        data: any;
    };
}
/**
 * 校验验证码数据，校验成功返回undefined，校验失败返回失败文字
 * @param options
 */
export declare function validCaptcha(options: ValidCaptchaOptions): Promise<string | void>;
