import { aesEncrypt, base64Encode } from '../utils/security'
import { InternalApiAxiosRequestConfig } from './types'

/**
 * 加密请求的数据
 */
export default function encryptRequest(
    config: InternalApiAxiosRequestConfig,
): InternalApiAxiosRequestConfig {
    const { encryption_key, data } = config

    //如果没有设置密钥就不加密了
    if (!encryption_key) return config

    const { name, key, iv } = encryption_key

    //先得到原始请求体的JSON字符串
    const json = JSON.stringify(data ?? {})
    //先进行aes加密
    const encrypted = aesEncrypt(json, key, iv)
    //接下来是base64转码
    const base64 = base64Encode(encrypted)
    //最后做一次urlencode
    const urlEncoded = encodeURIComponent(base64)

    //写入请求体
    config.data = {
        sign_data: urlEncoded,
    }
    //在请求头中写入密钥名
    config.headers.set('sign_name', name)

    return config
}
