import CryptoJS from 'crypto-js'

export function md5(input: string): string {
    return CryptoJS.MD5(input).toString(CryptoJS.enc.Hex).toLowerCase()
}

/**
 * base64编码
 * @param input 待编码的字符串
 */
export function base64Encode(input: string): string {
    return CryptoJS.enc.Base64.stringify(CryptoJS.enc.Utf8.parse(input))
}

/**
 * base64解码
 * @param input 待解码的字符串
 */
export function base64Decode(input: string): string {
    return CryptoJS.enc.Utf8.stringify(CryptoJS.enc.Base64.parse(input))
}

/**
 * AES-CBC-128加密
 * @param input 待加密的数据
 * @param key 密钥
 * @param iv 向量
 */
export function aesEncrypt(input: string, key: string, iv: string): string {
    return CryptoJS.AES.encrypt(input, CryptoJS.enc.Utf8.parse(key), {
        iv: CryptoJS.enc.Utf8.parse(iv),
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
    }).toString()
}

/**
 * AES-CBC-128解密
 * @param input 待加密的数据
 * @param key 密钥
 * @param iv 向量
 */
export function aesDecrypt(input: string, key: string, iv: string): string {
    return CryptoJS.AES.decrypt(input, CryptoJS.enc.Utf8.parse(key), {
        iv: CryptoJS.enc.Utf8.parse(iv),
        mode: CryptoJS.mode.CBC,
        padding: CryptoJS.pad.Pkcs7,
    }).toString(CryptoJS.enc.Utf8)
}
