import { aesDecrypt, base64Decode } from '../utils/security'
import { ApiAxiosResponse } from './types'

/**
 * 解密响应体数据
 * @param response
 */
export default function decryptResponse(
    response: ApiAxiosResponse<any, { encrypted_data?: string | null }>,
): ApiAxiosResponse {
    //响应体不是对象
    if (typeof response.data !== 'object' || !response.data) return response
    //响应体上没有encrypted_data属性
    if (typeof response.data.encrypted_data !== 'string' || !response.data.encrypted_data)
        return response
    //请求配置上没有加解密参数
    if (!response.config.encryption_key) return response

    //进行解密，先做一次aes解密
    const { key, iv } = response.config.encryption_key
    const decrypted = aesDecrypt(response.data.encrypted_data, key, iv)

    //然后做一次base64解码
    const base64_decoded = base64Decode(decrypted)

    //最后做一次url解码
    const url_decoded = decodeURIComponent(base64_decoded)

    //JSON解析并覆盖原data属性
    response.data.data = JSON.parse(url_decoded)

    return response
}
