import { AxiosRequestHeaders } from 'axios'
import { unixTimestamp } from '../utils/datetime'
import { md5 } from '../utils/security'
import { InternalApiAxiosRequestConfig } from './types'

/**
 * 自动向请求中注入公参
 * @param config
 */
export default function injectCommonParams(
    config: InternalApiAxiosRequestConfig,
): InternalApiAxiosRequestConfig {
    fillHeader(config.headers, 'source', () => config.source)
    fillHeader(config.headers, 'device', () => config.device)
    fillHeader(config.headers, 'appversion', () => config.app_version)
    fillHeader(config.headers, 'token', () => config.token)
    fillHeader(config.headers, 'partner_key', () => config.partner_key)
    fillHeader(config.headers, 'sdk_version', () => config.sdk_version)
    fillHeader(config.headers, 'timestamp', () => unixTimestamp().toString())
    fillHeader(config.headers, 'request_number', () => md5((Date.now() + Math.random()).toString()))
    return config
}

/**
 * 向请求头中注入公参，如果已经设置了对应的请求头则不再覆盖
 */
export function fillHeader(
    headers: AxiosRequestHeaders,
    name: string,
    creator: () => string | undefined,
): void {
    if (headers.has(name)) return
    const value = creator()
    if (value) {
        headers.set(name, value)
    }
}
