import Cookies from 'js-cookie'

/**
 * 通过app获取到的状态
 */
export interface AppStatus {
    /**
     * 包名
     */
    source: string
    /**
     * 是否在直播间中
     */
    isOnLiveRoom: number
    /**
     * 当前直播间的房间号
     */
    roomIdentifier: number
    /**
     * 当前用户的token
     */
    app_token: string
    /**
     * 加密后的用户id
     */
    userid: string
    /**
     * 是否能使用内购
     */
    canUseIAP: boolean
}

/**
 * 读取当前APP的状态
 */
export function getAppStatus(): AppStatus | undefined {
    //先判断是否在app内
    const platform = Cookies.get('platform')
    const source = Cookies.get('source')

    if (platform !== 'app' || !source) return

    return {
        source,
        app_token: Cookies.get('app_token') ?? '',
        isOnLiveRoom: parseInt(Cookies.get('isOnLiveRoom') ?? '0'),
        roomIdentifier: parseInt(Cookies.get('roomIdentifier') || '0'),
        userid: Cookies.get('userid') ?? '',
        canUseIAP: Cookies.get('canUseIAP') === 'true',
    }
}
