import BaseEntities from "entities/BaseEntities";
import { IsInt, IsString } from "class-validator";
import useErrorMessage from "@/utils/useErrorMessage";

export default class Gift extends BaseEntities {
	@IsString({ message: useErrorMessage("img", "string") })
	img = "";
	@IsString({ message: useErrorMessage("name", "string") })
	name = "";
	@IsString({ message: useErrorMessage("key", "string") })
	key = "";
	// -1表示未抽中  1 表示已抽中
	@IsInt({ message: useErrorMessage("is", "int") })
	is = -1;
}
