import "reflect-metadata";
import { createApp } from "vue";
import App from "views/app/App.vue";
import pinia from "@/store/pinia";
import router from "@/router";
import { Lazyload } from "vant";
import vShowImg from "@/directives/showImage";

import messages from "@/locales/index";
import { createI18n } from "vue-i18n";
import { getLocale } from "./locales/locale";

const app = createApp(App);
app.use(pinia);
app.directive("showImage", vShowImg);
app.use(Lazyload, {
	lazyComponent: true
});

const lang = getLocale();
localStorage.setItem("lang",lang);
const i18n = createI18n({
	legacy: false,
	locale: lang,
	messages
});
app.use(i18n);
// 使用 i18n 插件
app.use(createI18n);

app.use(router);
app.mount("#app");
