import usePosition from "views/index/components/lottery/hooks/usePosition";
import anime from "animejs";
import usePxToVw from "@/utils/usePxToVw";
import { Ref } from "vue";
import { $handlePrizeDraw } from "views/index/request";
import Tips from "entities/Tips";
import Gift from "views/index/entities/Gift";
import { ToastWrapperInstance } from "vant";

interface Params {
	show: Ref<boolean>;
}

export default ({ show }: Params) => {
	const showText = ref(false);
	const ulRef = ref<HTMLUListElement>();
	const { startAnimeP } = usePosition();
	const gift: Gift = reactive(new Gift());
	let selectFlag = true;
	const sureFlag = ref(false);
	const selectIndex = ref(-1);
	// 调用抽奖接口
	const handlePrizeDraw = async (index: number) => {
		const { code, msg, data } = await $handlePrizeDraw(index);
		if (code !== 200) {
			Tips.showToast(msg, "fail");
			return false;
		}
		return data;
	};
	const startAnime = () => {
		const ulEle = ulRef.value;
		if (ulEle) {
			const lis = ulEle.querySelectorAll("li");
			for (let i = 0; i < lis.length; i++) {
				const t = anime.timeline({});
				t.add({
					targets: lis[i],
					translateX: usePxToVw(startAnimeP[i].x),
					translateY: usePxToVw(startAnimeP[i].y),
					delay: i * 50
				});
				t.add({
					targets: lis[i],
					translateX: 0,
					translateY: 0,
					delay: i * 50,
					update(anim) {
						if (i === lis.length - 1 && anim.progress === 100) {
							showText.value = true;
							selectFlag = false;
						}
					}
				});
			}
		} else {
			nextTick(startAnime);
		}
	};

	// 选中弹开
	const selectAnime = async (index: number) => {
		if (selectFlag) return;

		const loading: ToastWrapperInstance = Tips.showLoading({
			duration: 0
		});
		const result = await handlePrizeDraw(index);
		loading.close();
		if (result) {
			sureFlag.value = true;
			selectFlag = true;
			const g = Gift.transform(Gift, result);
			const errors = await g.validator();
			if (errors.length > 0) return Tips.showToast(errors[0], "fail");
			Object.assign(gift, g);
			selectFlag = true;
			sureFlag.value = true;
			selectIndex.value = index;
			/*const ulEle = ulRef.value;
			if (ulEle) {
				const ele = ulEle.querySelectorAll("li")[index];
				const div = ele.querySelector("div");
				const imgEle = ele.querySelector(".mask");
				const duration = 1;
				if (ele && div && imgEle) {
					anime({
						targets: ele,
						scale: 3,
						translateX: selectAnimeP[index].x,
						translateY: selectAnimeP[index].y,
						zIndex: [9, 9],
						duration
					});
					anime({
						targets: div,
						rotateY: [0, 360],
						duration
					});
					anime({
						targets: imgEle,
						rotateY: [0, 360],
						duration,
						update(anim) {
							if (anim.progress === 100) {
								sureFlag.value = true;
								selectIndex.value = index;
							}
						}
					});
				}
			}*/
		}
	};
	watch(show, value => {
		if (value) {
			setTimeout(startAnime, 1000);
		}
	});

	return {
		showText,
		ulRef,
		startAnime,
		selectAnime,
		sureFlag,
		gift,
		selectIndex
	};
};
