// import EverydayGift from "views/index/components/everydayGift/EverydayGift.vue";
import FirstGift from "views/index/components/firstGift/FirstGift.vue";
import useSwiper from "views/index/hooks/useSwiper";
import { useI18n } from "vue-i18n";
export interface SwiperData {
	title: string;
	component: Component;
	backgroundColor: string;
	backgroundImg: string;
}

export default () => {
	const { t } = useI18n();
	const swiperData: SwiperData[] = [
		{
			title: t("tag"),
			component: FirstGift,
			backgroundColor: "#F8505D",
			backgroundImg: "index/one"
		}

	];
	const { activeIndex, setActiveIndex, swiperRef, init } = useSwiper();
	onMounted(() => {
		init({
			allowTouchMove: false,
			initialSlide: 0
		});
	});
	return {
		swiperData,
		activeIndex,
		setActiveIndex,
		swiperRef
	};
};
