interface OpenInstallOption {
	appKey: string; // appKey必选参数，OpenInstall为每个应用分配的ID
	channelCode?: string; // 直接指定渠道编号，默认通过当前页url中的channelCode参数自动检测渠道编号
	mask?: () => string;
	onready?: () => string;
}

declare interface Window {
	// 获取首充礼包数据（app回调）
	fetchFirstRechargeProduct: (data: string) => void;
	inApplicationIAPRechargeListener: (callback: () => void) => void;
	webkit: {
		messageHandlers: {
			openShareTip: {
				postMessage: (param) => void; // ios分享
			};
			closeWeb: {
				postMessage: (data) => void; // ios关闭webview
			};
			toPerson: {
				postMessage: (data) => void;
			};
			actionAsPhp: {
				// 进入个人中心 / 支付
				postMessage: (param) => void;
			};
			toLiveroom: {
				// 进入直播间
				postMessage: (param) => void;
			};
			getStatusBarHeight: {
				postMessage: () => number;
			};
			selecetTabBarItem: {
				postMessage: (param: { index: number | string }) => void;
			};
			fetchFirstRechargeProduct: {
				postMessage: (p: boolean) => void;
			};
			buyFirstRechargeProduct: {
				postMessage: (p: { productIdentifier: string }) => void;
			};
		};
	};
	liveapp: {
		openShareTip: (param: string) => void;
		closeWeb: () => void;
		toPerson: (text) => void;
		actionAsPhp: (str: string) => void;
		toLiveroom: (param: string) => void;
		getStatusBarHeight: () => number;
		selecetTabBarItem: (param: string) => void;
		fetchFirstRechargeProduct: () => void;
		buyFirstRechargeProduct: (productIdentifier: string) => void;
	};
	OpenInstall;
}
