import FirstGift from "entities/FirstGift";
import useSwiper from "views/index/hooks/useSwiper";
import handleApp from "@/utils/HandleApp";
import useCookieStore from "@/store/useCookieStore";
import { $queryFirstBuy } from "views/index/request";
import { showFailToast } from "vant";
import Tips from "entities/Tips";

import { useI18n } from "vue-i18n";


export default () => {
	const { t } = useI18n();

	const defaultGiftList = [
		{
			title: t("title1"),
			src: "index/lv1",
			ratio: 1.8
		},
		{
			title: t("title2"),
			src: "index/lv2",
			ratio: 1.4
		},
		{
			title: t("title3"),
			src: "index/lv3",
			ratio: 1.93333333
		},
		{
			title: t("title4"),
			src: "index/lv4",
			ratio: 2.2
		},
		{
			title: t("title5"),
			src: "index/lv5",
			ratio: 2.5
		}
	];
	const giftList: FirstGift[] = reactive([]);
	const whetherPay = ref<-1 | 0 | 1 | 2>(-1);
	defaultGiftList.forEach(item => {
		giftList.push(new FirstGift(item.title, item.src, item.ratio));
	});

	const cookieStore = useCookieStore();
	const { swiperRef, setActiveIndex, activeIndex, init } = useSwiper();

	// 调用原生api，跳转首充页面
	const buyFirstRechargeProduct = (firstGift: FirstGift) => {
		if (whetherPay.value === 2) return Tips.showToast({ message: t("tishi") });
		if (whetherPay.value === 1) handleApp.buyFirstRechargeProduct(firstGift.productIdentifier);
	};
	const queryFirstBuy = async () => {
		const { code, msg, data } = await $queryFirstBuy();
		if (code !== 200) return showFailToast(msg);
		whetherPay.value = data.status;
	};

	onBeforeMount(() => {
		window.fetchFirstRechargeProduct = (data: string) => {
			const list: FirstGift[] = JSON.parse(data);
			console.log("获取原生价格列表", list);
			list.forEach((item, index) => {
				const current = giftList[index];
				current.productIdentifier = item.productIdentifier;
				current.productName = item.productName;
				current.productLocaleSymbol = item.productLocaleSymbol;
				current.productPrice = item.productPrice;
			});
		};
	});
	onMounted(queryFirstBuy);
	onMounted(init);
	onMounted(() => {
		cookieStore.cookieData.platform === "app" && handleApp.fetchFirstRechargeProduct();
	});
	window.inApplicationIAPRechargeListener = () => {
		console.log("用于测试， 原生调用web");
		queryFirstBuy();
	};
	return {
		giftList,
		swiperRef,
		activeIndex,
		setActiveIndex,
		buyFirstRechargeProduct,
		whetherPay
	};
};
