import { AES, enc, mode, pad } from "crypto-js";

const { CBC } = mode;
const { Pkcs7 } = pad;
const { parse } = enc.Utf8;

export const decodeData = (str: string, secret: Secret) => {
	return AES.decrypt(str, parse(secret.key), {
		iv: enc.Utf8.parse(secret.iv),
		mode: CBC,
		padding: Pkcs7
	}).toString(enc.Utf8);
};
export const encodeData = (data: string, secret: Secret) =>
	AES.encrypt(data, parse(secret.key), {
		iv: enc.Utf8.parse(secret.iv),
		mode: CBC,
		padding: Pkcs7
	}).toString();
