import BaseEntities from "entities/BaseEntities";
import { IsInt, IsString } from "class-validator";
import useErrorMessage from "@/utils/useErrorMessage";

export default class FirstGift extends BaseEntities {
	@IsString({ message: useErrorMessage("title", "string") })
	title = "";
	@IsString({ message: useErrorMessage("title", "string") })
	src = "";
	@IsString({ message: useErrorMessage("productName", "string") })
	productName = "";
	@IsString({ message: useErrorMessage("productLocaleSymbol", "string") })
	productLocaleSymbol = "￥";
	@IsInt({ message: useErrorMessage("productPrice", "int") })
	productPrice = 0;
	@IsString({ message: useErrorMessage("productIdentifier", "string") })
	productIdentifier = "";
	@IsInt({ message: useErrorMessage("ratio", "int") })
	ratio = 0;
	constructor(title?: string, src?: string, ratio?: number) {
		super();
		if (title) this.title = title;
		if (src) this.src = src;
		if (ratio) this.ratio = ratio;
	}
}
