// 添加头公参函数
import piniaObj from "@/store/pinia";
import useRequestData from "@/store/useRequestData";
import useCookieStore from "@/store/useCookieStore";
import md5 from "md5";
import useChat from "@/request/useChat";
import { random } from "lodash";
const requestStore = useRequestData(piniaObj);
const cookieStore = useCookieStore(piniaObj);
const chatList = useChat();
const lang = localStorage.getItem("lang") || "en";
export default (sign_name: string, customSignName = "", params: unknown = {}) => {
	const data: Record<string, string> = {
		device: "wap",
		source: cookieStore.cookieData.source || "xinxiuweb",
		request_number: Math.random().toString(),
		timestamp: Math.floor(Date.now() / 1000).toString(),
		appversion: "1.0.0",
		token: requestStore.requestData.token,
		lang:lang
	};
	if (typeof params === "object") {
		// 这里偷懒直接合并了， 正常应该去除公参的key ，不过如果 body的公参的key冲突了 其实也是不合理的， 我觉得这个应该是后端设计的问题
		Object.assign(data, params);
	}
	let signature = "";
	const keys = Object.keys(data);
	keys.sort();
	keys.forEach(item => {
		if (data[item] !== undefined) {
			signature += data[item];
		}
	});
	signature += "asdasgfdwqew";
	signature = md5(md5(signature));
	for (let i = 0; i < 11; i++) {
		if (i < 5) {
			signature = chatList[random(0, 61)] + signature;
		} else {
			signature += chatList[random(0, 61)];
		}
	}
	data.signature = signature;
	if (sign_name) {
		data.sign_name = sign_name;
	}
	if (customSignName.length > 0) {
		data.sign_name = customSignName;
	}
	return data;
};
