import { IsArray, IsInt, ValidateNested } from "class-validator";
import useErrorMessage from "@/utils/useErrorMessage";
import Gift from "views/index/entities/Gift";
import { Type } from "class-transformer";
import BaseEntities from "entities/BaseEntities";

export default class PrizeDraw extends BaseEntities {
	@IsInt({ message: useErrorMessage("number", "int") })
	number = -1;

	@IsArray({ message: useErrorMessage("data", "array") })
	@ValidateNested({ each: true })
	@Type(() => Gift)
	data: Gift[] = [];
}
