import PrizeDraw from "views/index/entities/PrizeDraw";
import { $getPrizeDraw } from "views/index/request";
import Tips from "entities/Tips";
import { ToastWrapperInstance } from "vant";

interface Props {
	setRuleShow: (flag: boolean) => void;
}
export default ({ setRuleShow }: Props) => {
	const prizeDraw: PrizeDraw = reactive(new PrizeDraw());
	const getPrizeDraw = async (): Promise<ToastWrapperInstance | undefined> => {
		const { data, code, msg } = await $getPrizeDraw();
		if (code !== 200) return Tips.showToast(msg, "fail");
		const p: PrizeDraw = PrizeDraw.transform(PrizeDraw, data);
		const errors: string[] = await p.validator();
		if (errors.length > 0) return Tips.showToast(errors[0], "fail");
		Object.assign(prizeDraw, p);
	};
	onMounted(getPrizeDraw);
	const show = ref(true);
	// 开始抽奖
	const startPrizeDraw = (flag: boolean) => {
		show.value = flag;
	};
	// 抽奖完毕点击收下
	const endPrizeDraw = async () => {
		await getPrizeDraw();
		show.value = true;
		setRuleShow(false);
	};
	return {
		prizeDraw,
		startPrizeDraw,
		show,
		endPrizeDraw,
		getPrizeDraw
	};
};
