import { Swiper } from "swiper";
import "swiper/swiper-bundle.css";
import type { SwiperOptions } from "swiper/types/swiper-options";

export default () => {
	let swiper: Swiper;
	const swiperRef = ref<HTMLDivElement>();
	const activeIndex = ref(0);
	const setActiveIndex = (index: number) => {
		if (swiper) {
			swiper.slideTo(index);
			activeIndex.value = index;
		} else {
			init();
			nextTick(() => {
				setActiveIndex(index);
			});
		}
	};
	const init = (option: SwiperOptions = {}) => {
		const ele = swiperRef.value;
		if (ele) {
			swiper = new Swiper(ele, {
				on: {
					slideChange(e: Swiper) {
						activeIndex.value = e.activeIndex;
					}
				},
				...option
			});
		}
	};
	return {
		init,
		setActiveIndex,
		activeIndex,
		swiperRef
	};
};
