# 文档预览系统

这是一个简单的文档预览系统，支持PDF和Word文档的在线预览。

## 功能特性

* PDF文档在线预览（使用PDF.js）
* Word文档在线预览（使用Google Docs Viewer）
* 拖拽上传文件
* 响应式设计，适合各种设备
* 简洁现代的用户界面

## 安装与使用

### 系统要求

* 支持PHP 7.0+的Web服务器（Apache/Nginx）
* 启用mod_rewrite模块（Apache）
* 启用文件上传功能

### 安装步骤

1. 将所有文件上传到Web服务器目录
2. 确保`uploads`目录可写（权限设为755或777）
3. 确保PHP文件上传配置正确（php.ini中的upload_max_filesize和post_max_size）

### 配置说明

系统主要包含以下文件：

* `cs.html` - 主页面，包含文档预览功能
* `upload_word.php` - 处理Word文档上传的PHP脚本
* `.htaccess` - Apache服务器配置文件
* `uploads/` - 上传文件存储目录（会自动创建）

## 使用方法

1. 访问`cs.html`页面
2. 选择要预览的文档类型（PDF或Word）
3. 点击上传区域或拖拽文件到上传区域
4. 等待文件上传并预览

## 注意事项

* PDF预览完全在客户端进行，无需服务器端处理
* Word预览需要上传文件到服务器，然后使用Google Docs Viewer进行预览
* 由于Google Docs Viewer安全限制，预览的文件URL必须是公开可访问的
* 在实际应用中，可能需要考虑文件访问权限、存储限制等问题

## 技术实现

* 前端：HTML5、CSS3、JavaScript
* PDF预览：PDF.js库
* Word预览：Google Docs Viewer
* 后端：PHP
* 服务器：Apache（带mod_rewrite）